/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.localization.LocalizationService;

public abstract class Localization {
    public static String getString(String key) {
        return Localization.getService().getBundle().getString(key);
    }

    public static String getString(Locale locale, String key) {
        return Localization.getService().getString(null, locale, key);
    }

    public static String getString(String bundleName, Locale locale, String key) {
        return Localization.getService().getString(bundleName, locale, key);
    }

    public static String getString(HttpServletRequest req, String key) {
        return Localization.getService().getBundle(req).getString(key);
    }

    public static String getString(String key, String lang) {
        return Localization.getBundle(Localization.getDefaultBundleName(), new Locale(lang, "")).getString(key);
    }

    public static ResourceBundle getBundle(String bundleName) {
        return Localization.getService().getBundle(bundleName);
    }

    public static ResourceBundle getBundle(String bundleName, String languageHeader) {
        return Localization.getService().getBundle(bundleName, languageHeader);
    }

    public static ResourceBundle getBundle(HttpServletRequest req) {
        return Localization.getService().getBundle(req);
    }

    public static ResourceBundle getBundle(String bundleName, HttpServletRequest req) {
        return Localization.getService().getBundle(bundleName, req);
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        return Localization.getService().getBundle(bundleName, locale);
    }

    public static void setBundle(String defaultBundle) {
        Localization.getService().setBundle(defaultBundle);
    }

    public static Locale getLocale(HttpServletRequest req) {
        return Localization.getService().getLocale(req);
    }

    public static Locale getLocale(String languageHeader) {
        return Localization.getService().getLocale(languageHeader);
    }

    public static String getDefaultBundleName() {
        return Localization.getService().getDefaultBundleName();
    }

    public static String getDefaultCountry() {
        return Localization.getService().getDefaultCountry();
    }

    public static String getDefaultLanguage() {
        return Localization.getService().getDefaultLanguage();
    }

    protected static final LocalizationService getService() {
        return (LocalizationService)TurbineServices.getInstance().getService("LocalizationService");
    }

    public static String format(String bundleName, Locale locale, String key, Object arg1) {
        return Localization.getService().format(bundleName, locale, key, arg1);
    }

    public static String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
        return Localization.getService().format(bundleName, locale, key, arg1, arg2);
    }

    public static String format(String bundleName, Locale locale, String key, Object[] args) {
        return Localization.getService().format(bundleName, locale, key, args);
    }

    public static String getString(String key, Locale locale) {
        return Localization.getString(locale, key);
    }

    public static String getString(String key, HttpServletRequest req) {
        return Localization.getString(req, key);
    }
}

