/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.log4j.Category;

public class BigDecimalField
extends Field {
    Category category = Category.getInstance((String)this.getClass().getName());

    public BigDecimalField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = new BigDecimal(prop);
        }
        catch (RuntimeException e) {
            this.category.error((Object)("Could not convert " + prop + " into a BigDecimal. (" + this.name + ")"));
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.NumberValidator";
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] inputs = this.pp.getStrings(this.getKey());
            BigDecimal[] values = new BigDecimal[inputs.length];
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i] != null && inputs[i].length() > 0) {
                    values[i] = this.canonicalizeDecimalInput(inputs[i]);
                }
                ++i;
            }
            this.setTestValue(values);
        } else {
            String s = this.pp.getString(this.getKey());
            if (s != null && s.length() > 0) {
                this.setTestValue(this.canonicalizeDecimalInput(s));
            } else {
                this.set_flag = false;
            }
        }
    }

    protected final BigDecimal canonicalizeDecimalInput(String bigDecimal) {
        DecimalFormatSymbols user;
        DecimalFormatSymbols internal;
        if (this.getLocale() != null && !(internal = new DecimalFormatSymbols()).equals(user = new DecimalFormatSymbols(this.getLocale()))) {
            bigDecimal = bigDecimal.replace(user.getDecimalSeparator(), internal.getDecimalSeparator());
        }
        return new BigDecimal(bigDecimal);
    }
}

