/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.TurbineServices;
import org.apache.fulcrum.crypto.CryptoAlgorithm;
import org.apache.fulcrum.crypto.CryptoService;
import org.apache.fulcrum.factory.FactoryService;

public class TurbineCryptoService
extends BaseService
implements CryptoService {
    private static final String ALGORITHM = "algorithm";
    private static final String DEFAULT_KEY = "default";
    private static final String DEFAULT_CLASS = "org.apache.fulcrum.crypto.provider.JavaCrypt";
    private Hashtable algos = null;
    private FactoryService factoryService = null;

    public void init() throws InitializationException {
        this.algos = new Hashtable();
        this.algos.put(DEFAULT_KEY, DEFAULT_CLASS);
        Configuration conf = this.getConfiguration().subset(ALGORITHM);
        if (conf != null) {
            Iterator it = conf.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = conf.getString(key);
                this.algos.put(key, val);
            }
        }
        try {
            this.factoryService = (FactoryService)TurbineServices.getInstance().getService("FactoryService");
        }
        catch (Exception e) {
            throw new InitializationException("TurbineCryptoService.init: Failed to get a Factory object", e);
        }
        this.setInit(true);
    }

    public CryptoAlgorithm getCryptoAlgorithm(String algo) throws NoSuchAlgorithmException {
        String cryptoClass = (String)this.algos.get(algo);
        CryptoAlgorithm ca = null;
        if (cryptoClass == null) {
            cryptoClass = (String)this.algos.get(DEFAULT_KEY);
        }
        if (cryptoClass == null || cryptoClass.equalsIgnoreCase("none")) {
            throw new NoSuchAlgorithmException("TurbineCryptoService: No Algorithm for " + algo + " found");
        }
        try {
            ca = (CryptoAlgorithm)this.factoryService.getInstance(cryptoClass);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("TurbineCryptoService: Error instantiating " + cryptoClass + " for " + algo);
        }
        ca.setCipher(algo);
        return ca;
    }

    static {
        ALGORITHM = ALGORITHM;
        DEFAULT_KEY = DEFAULT_KEY;
        DEFAULT_CLASS = DEFAULT_CLASS;
    }
}

