/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cactus.server.ServletContextWrapper;

public class ServletConfigWrapper
implements ServletConfig {
    private ServletConfig originalConfig;
    private Hashtable initParameters;
    private String servletName;

    public ServletConfigWrapper(ServletConfig theOriginalConfig) {
        this.originalConfig = theOriginalConfig;
        this.initParameters = new Hashtable();
    }

    public void setInitParameter(String theName, String theValue) {
        this.initParameters.put(theName, theValue);
    }

    public void setServletName(String theServletName) {
        this.servletName = theServletName;
    }

    public ServletContext getServletContext() {
        return new ServletContextWrapper(this.originalConfig.getServletContext());
    }

    public String getInitParameter(String theName) {
        String value = (String)this.initParameters.get(theName);
        if (value == null) {
            value = this.originalConfig.getInitParameter(theName);
        }
        return value;
    }

    public Enumeration getInitParameterNames() {
        String value;
        Vector<String> names = new Vector<String>();
        Enumeration enumeration = this.initParameters.keys();
        while (enumeration.hasMoreElements()) {
            value = (String)enumeration.nextElement();
            names.add(value);
        }
        enumeration = this.originalConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            value = (String)enumeration.nextElement();
            names.add(value);
        }
        return names.elements();
    }

    public String getServletName() {
        if (this.servletName != null) {
            return this.servletName;
        }
        return this.originalConfig.getServletName();
    }
}

