/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected ConnectionFactory _connFactory = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected boolean _defaultReadOnly = false;
    protected boolean _defaultAutoCommit = true;
    protected AbandonedConfig _config = null;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) throws Exception {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void activateObject(Object obj) throws Exception {
        block5: {
            if (obj instanceof DelegatingConnection) {
                ((DelegatingConnection)obj).activate();
            }
            if (!(obj instanceof Connection)) break block5;
            Connection conn = (Connection)obj;
            try {
                conn.setAutoCommit(this._defaultAutoCommit);
            }
            catch (SQLException sQLException) {}
            try {
                conn.setReadOnly(this._defaultReadOnly);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PoolableConnection) {
            try {
                ((PoolableConnection)obj).reallyClose();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException sQLException) {
            }
        }
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (this._stmtPoolFactory != null) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)conn));
        }
        return new PoolableConnection(conn, this._pool, this._config);
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).passivate();
        }
    }

    public synchronized void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly;
    }

    public synchronized void setPool(ObjectPool pool) {
        if (this._pool != null && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {}
        }
        this._pool = pool;
    }

    public synchronized void setStatementPoolFactory(KeyedObjectPoolFactory stmtPoolFactory) {
        this._stmtPoolFactory = stmtPoolFactory;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean validateObject(Object obj) {
        boolean bl;
        ResultSet rset;
        Statement stmt;
        block19: {
            boolean bl2;
            block18: {
                if (!(obj instanceof Connection)) return false;
                String query = this._validationQuery;
                Connection conn = (Connection)obj;
                try {
                    if (conn.isClosed()) {
                        return false;
                    }
                }
                catch (SQLException sQLException) {
                    return false;
                }
                if (query == null) return true;
                stmt = null;
                rset = null;
                try {
                    try {
                        stmt = conn.createStatement();
                        rset = stmt.executeQuery(query);
                        if (rset.next()) {
                            bl2 = true;
                            Object var8_9 = null;
                            break block18;
                        }
                        bl = false;
                        break block19;
                    }
                    catch (Exception exception) {
                        boolean bl3 = false;
                        Object var8_11 = null;
                        try {
                            rset.close();
                        }
                        catch (Exception exception2) {}
                        try {
                            stmt.close();
                            return bl3;
                        }
                        catch (Exception exception3) {}
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    try {}
                    catch (Exception exception) {}
                    rset.close();
                    try {}
                    catch (Exception exception) {}
                    stmt.close();
                    throw throwable;
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {}
            rset.close();
            try {}
            catch (Exception exception) {}
            stmt.close();
            return bl2;
        }
        Object var8_10 = null;
        try {}
        catch (Exception exception) {}
        rset.close();
        try {}
        catch (Exception exception) {}
        stmt.close();
        return bl;
    }
}

