/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;

public class DelegatingConnection
extends AbandonedTrace
implements Connection {
    protected Connection _conn = null;
    protected boolean _closed = false;

    public DelegatingConnection(Connection c) {
        this._conn = c;
    }

    public DelegatingConnection(Connection c, AbandonedConfig config) {
        super(config);
        this._conn = c;
    }

    protected void activate() {
        this._closed = false;
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).activate();
        }
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._conn.clearWarnings();
    }

    public void close() throws SQLException {
        this.passivate();
        this._conn.close();
    }

    public void commit() throws SQLException {
        this.checkOpen();
        this._conn.commit();
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new DelegatingStatement(this, this._conn.createStatement());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new DelegatingStatement(this, this._conn.createStatement(resultSetType, resultSetConcurrency));
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._conn.getCatalog();
    }

    public Connection getDelegate() {
        return this._conn;
    }

    public Connection getInnermostDelegate() {
        Connection c = this._conn;
        while (c != null && c instanceof DelegatingConnection) {
            if (this != (c = ((DelegatingConnection)c).getDelegate())) continue;
            return null;
        }
        return c;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this._conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._conn.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this._closed || this._conn.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._conn.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return this._conn.nativeSQL(sql);
    }

    protected void passivate() throws SQLException {
        this._closed = true;
        List statements = this.getTrace();
        if (statements != null) {
            Statement[] set = new Statement[statements.size()];
            statements.toArray(set);
            int i = 0;
            while (i < set.length) {
                set[i].close();
                ++i;
            }
            this.clearTrace();
        }
        this.setLastUsed(0L);
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).passivate();
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        return new DelegatingCallableStatement(this, this._conn.prepareCall(sql));
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new DelegatingCallableStatement(this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        this._conn.rollback();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this._conn.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this._conn.setCatalog(catalog);
    }

    public void setDelegate(Connection c) {
        this._conn = c;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this._conn.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this._conn.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this._conn.setTypeMap(map);
    }
}

