/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class SoftReferenceObjectPool
extends BaseObjectPool
implements ObjectPool {
    private List _pool = new ArrayList();
    private PoolableObjectFactory _factory = null;
    private int _numActive = 0;

    public SoftReferenceObjectPool() {
        this._factory = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this._factory = poolableObjectFactory;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory poolableObjectFactory, int n) throws Exception {
        this._factory = poolableObjectFactory;
        if (this._factory != null) {
            int n2 = 0;
            while (n2 < n) {
                Object object = this._factory.makeObject();
                this._factory.passivateObject(object);
                this._pool.add(new SoftReference<Object>(object));
                ++n2;
            }
        }
    }

    public synchronized Object borrowObject() throws Exception {
        Object object = null;
        while (object == null) {
            if (this._pool.isEmpty()) {
                if (this._factory == null) {
                    throw new NoSuchElementException();
                }
                object = this._factory.makeObject();
                continue;
            }
            SoftReference softReference = (SoftReference)this._pool.remove(this._pool.size() - 1);
            object = softReference.get();
        }
        if (this._factory != null && object != null) {
            this._factory.activateObject(object);
        }
        ++this._numActive;
        return object;
    }

    public synchronized void clear() {
        if (this._factory != null) {
            Iterator iterator = this._pool.iterator();
            while (iterator.hasNext()) {
                try {
                    Object t = ((SoftReference)iterator.next()).get();
                    if (t == null) continue;
                    this._factory.destroyObject(t);
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
    }

    public int getNumActive() {
        return this._numActive;
    }

    public int getNumIdle() {
        return this._pool.size();
    }

    public void returnObject(Object object) throws Exception {
        block10: {
            boolean bl = true;
            if (!this._factory.validateObject(object)) {
                bl = false;
            } else {
                try {
                    this._factory.passivateObject(object);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            boolean bl2 = bl ^ true;
            SoftReferenceObjectPool softReferenceObjectPool = this;
            synchronized (softReferenceObjectPool) {
                --this._numActive;
                if (bl) {
                    this._pool.add(new SoftReference<Object>(object));
                }
                this.notifyAll();
            }
            if (!bl2) break block10;
            try {
                this._factory.destroyObject(object);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        if (this.getNumActive() > 0) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }
}

