/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.util.GenericURI;
import org.apache.util.URIUtil;

public class HttpURL
extends GenericURI {
    public static final String scheme = "http";
    public static final int port = 80;
    static final long serialVersionUID = -7158031098595039458L;

    public HttpURL(String escapedHttpURL) {
        super(escapedHttpURL);
        this.setDefaultScheme(scheme);
        this.setDefaultPort(80);
    }

    public HttpURL(String host, int port, String path) {
        this(null, null, host, port, path, null);
    }

    public HttpURL(String host, int port, String path, String query) {
        this(null, null, host, port, path, query);
    }

    public HttpURL(String host, String path) {
        this(null, null, host, 80, path, null);
    }

    public HttpURL(String userName, String password, String host) {
        this(userName, password, host, 80, null, null);
    }

    public HttpURL(String userName, String password, String host, int port) {
        this(userName, password, host, port, null, null);
    }

    public HttpURL(String userName, String password, String host, int port, String path) {
        this(userName, password, host, port, path, null);
    }

    public HttpURL(String userName, String password, String host, int port, String path, String query) {
        super(String.valueOf(URIUtil.escape(scheme, URIUtil.schemeReserved())) + "://" + (userName == null ? "" : String.valueOf(URIUtil.escape(userName)) + (password == null ? "" : ":" + URIUtil.escape(password)) + "@") + URIUtil.escape(host, URIUtil.hostReserved()) + (port == 80 || port == -1 ? "" : ":" + port) + (path == null || path.equals("") ? "/" : URIUtil.escape(!path.startsWith("/") ? "/" + path : path, URIUtil.pathReserved())) + (query == null || query.equals("") ? "" : "?" + URIUtil.escape(query, URIUtil.queryReserved())));
        this.setDefaultScheme(scheme);
        this.setDefaultPort(port);
    }

    public HttpURL(String userName, String password, String host, String path) {
        this(userName, password, host, 80, path, null);
    }

    public HttpURL(String userName, String password, String host, String path, String query) {
        this(userName, password, host, 80, path, query);
    }

    public HttpURL(HttpURL httpURL, String path) {
        this(String.valueOf(httpURL.toString()) + (httpURL.toString().endsWith("/") ? "" : "/") + URIUtil.escape(path, URIUtil.pathReserved()));
    }

    protected int getDefaultPort() {
        return 80;
    }

    protected String getDefaultScheme() {
        return scheme;
    }

    public String getEscapedHttpURL() {
        return this.getHttpURL().toString();
    }

    public String getEscapedHttpURLExceptForPassword() throws MalformedURLException {
        return this.getHttpURLExceptForPassword().toString();
    }

    public String getEscapedHttpURLExceptForUserInfo() throws MalformedURLException {
        return this.getHttpURLExceptForUserInfo().toString();
    }

    public String getEscapedUserInfo() throws MalformedURLException {
        return HttpURL.getEscapedUserInfo(this.getEscapedURI());
    }

    public static String getEscapedUserInfo(String escapedURI) throws MalformedURLException {
        String authority = GenericURI.getEscapedAuthority(escapedURI);
        int to = authority.lastIndexOf("@");
        return to > 0 ? authority.substring(0, to) : null;
    }

    public HttpURL getHttpURL() {
        return new HttpURL(this.getEscapedURI());
    }

    public HttpURL getHttpURLExceptForPassword() throws MalformedURLException {
        HttpURL httpURL = this.getHttpURL();
        httpURL.setUserInfo(httpURL.getUserName(), null);
        return httpURL;
    }

    public HttpURL getHttpURLExceptForUserInfo() throws MalformedURLException {
        HttpURL httpURL = this.getHttpURL();
        httpURL.setUserInfo(null, null);
        return httpURL;
    }

    public String getName() {
        return HttpURL.getName(this.getEscapedURI());
    }

    public static String getName(String escapedPath) {
        String name = GenericURI.getPath(escapedPath);
        if (name.equals("/")) {
            return name;
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return URIUtil.unescape(name.substring(name.lastIndexOf("/") + 1));
    }

    public String getParent() {
        return HttpURL.getParent(this.getEscapedURI());
    }

    public static String getParent(String escapedPath) {
        String pathname = GenericURI.getPath(escapedPath);
        if (pathname.endsWith("/")) {
            int at = pathname.lastIndexOf("/");
            if (at > 0) {
                pathname = pathname.substring(0, at);
                at = pathname.lastIndexOf("/");
                pathname = pathname.substring(0, at + 1);
            }
        } else {
            int at = pathname.lastIndexOf("/");
            pathname = pathname.substring(0, at + 1);
        }
        return URIUtil.unescape(pathname);
    }

    public String getPassword() throws MalformedURLException {
        return HttpURL.getPassword(this.getEscapedURI());
    }

    public static String getPassword(String escapedURI) throws MalformedURLException {
        try {
            String userInfo = HttpURL.getEscapedUserInfo(escapedURI);
            int at = userInfo.indexOf(":");
            String password = at >= 0 ? userInfo.substring(at + 1) : null;
            return URIUtil.unescape(password);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getUnescapedHttpURL() {
        return URIUtil.unescape(this.getHttpURL().toString());
    }

    public String getUnescapedHttpURLExceptForPassword() throws MalformedURLException {
        return URIUtil.unescape(this.getHttpURLExceptForPassword().toString());
    }

    public String getUnescapedHttpURLExceptForUserInfo() throws MalformedURLException {
        return URIUtil.unescape(this.getHttpURLExceptForUserInfo().toString());
    }

    public String getUserInfo() throws MalformedURLException {
        return HttpURL.getUserInfo(this.getEscapedURI());
    }

    public static String getUserInfo(String escapedURI) throws MalformedURLException {
        return URIUtil.unescape(HttpURL.getEscapedUserInfo(escapedURI));
    }

    public String getUserName() throws MalformedURLException {
        return HttpURL.getUserName(this.getEscapedURI());
    }

    public static String getUserName(String escapedURI) throws MalformedURLException {
        try {
            String userInfo = HttpURL.getEscapedUserInfo(escapedURI);
            int to = userInfo.indexOf(":");
            String username = to > 0 ? userInfo.substring(0, to) : userInfo;
            return URIUtil.unescape(username);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void setUserInfo(String userName, String password) throws MalformedURLException {
        this.setEscapedURI(String.valueOf(this.getEscapedScheme()) + "://" + (userName == null ? "" : String.valueOf(URIUtil.escape(userName)) + (password == null ? "" : ":" + URIUtil.escape(password)) + "@") + this.getEscapedHostPort() + this.getEscapedPathQuery());
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.getUnescapedHttpURLExceptForUserInfo().toString());
    }
}

