/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.Serializable;
import java.net.MalformedURLException;
import org.apache.util.URIUtil;

public abstract class GenericURI
implements Serializable {
    private String URI;
    private String defaultScheme = null;
    private int defaultPort = -1;

    public GenericURI(String escapedURI) {
        this.URI = escapedURI;
    }

    public GenericURI(String scheme, String host, int port) {
        this(scheme, host, port, null, null);
    }

    public GenericURI(String scheme, String host, int port, String path) {
        this(scheme, host, port, path, null);
    }

    public GenericURI(String scheme, String host, int port, String path, String query) {
        this.URI = String.valueOf(URIUtil.escape(scheme, URIUtil.schemeReserved())) + "://" + URIUtil.escape(host, URIUtil.hostReserved()) + (port == this.defaultPort || port == -1 ? "" : ":" + port) + (path == null || path.equals("") ? "/" : URIUtil.escape(!path.startsWith("/") ? "/" + path : path, URIUtil.pathReserved())) + (query == null || query.equals("") ? "" : "?" + URIUtil.escape(query, URIUtil.queryReserved()));
    }

    public GenericURI(String scheme, String host, String path) {
        this(scheme, host, -1, path, null);
    }

    public GenericURI(String scheme, String host, String path, String query) {
        this(scheme, host, -1, path, null);
    }

    public boolean equals(Object obj) {
        block3: {
            if (obj == null || !(obj instanceof GenericURI)) break block3;
            try {
                GenericURI URI2 = (GenericURI)obj;
                if (this.getEscapedScheme().equalsIgnoreCase(URI2.getEscapedScheme()) && this.getEscapedHost().equalsIgnoreCase(URI2.getEscapedHost()) && this.getPort() == URI2.getPort() && this.getEscapedPathQuery().equals(URI2.getEscapedPathQuery())) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    public String getAuthority() throws MalformedURLException {
        return GenericURI.getAuthority(this.URI);
    }

    public static String getAuthority(String escapedURI) throws MalformedURLException {
        return URIUtil.unescape(GenericURI.getEscapedAuthority(escapedURI));
    }

    protected abstract int getDefaultPort();

    protected abstract String getDefaultScheme();

    public String getEscapedAuthority() throws MalformedURLException {
        return GenericURI.getEscapedAuthority(this.URI);
    }

    public static String getEscapedAuthority(String escapedURI) throws MalformedURLException {
        int at = escapedURI.indexOf("://");
        if (at > 0) {
            int from = at + 3;
            int to = escapedURI.indexOf("/", from);
            return to > 0 ? escapedURI.substring(from, to) : escapedURI.substring(from);
        }
        throw new MalformedURLException("No scheme: " + escapedURI);
    }

    public String getEscapedFragment() throws MalformedURLException {
        return GenericURI.getEscapedFragment(this.URI);
    }

    public static String getEscapedFragment(String escapedURI) throws MalformedURLException {
        int at = escapedURI.indexOf("//");
        int n = at = at > 0 ? escapedURI.indexOf("/", at + 2) : escapedURI.indexOf("/");
        if (at > 0) {
            int from = escapedURI.lastIndexOf("#", at) > 0 ? escapedURI.lastIndexOf("#", at) + 1 : -1;
            return from > 0 ? escapedURI.substring(from) : null;
        }
        throw new MalformedURLException("Need to have the path part");
    }

    public String getEscapedHost() throws MalformedURLException {
        return GenericURI.getEscapedHost(this.URI);
    }

    public static String getEscapedHost(String escapedURI) throws MalformedURLException {
        String hostPort = GenericURI.getEscapedHostPort(escapedURI);
        int to = hostPort.lastIndexOf(":");
        return to > 0 ? hostPort.substring(0, to) : hostPort;
    }

    public String getEscapedHostPort() throws MalformedURLException {
        return GenericURI.getEscapedHostPort(this.URI);
    }

    public static String getEscapedHostPort(String escapedURI) throws MalformedURLException {
        String authority = GenericURI.getEscapedAuthority(escapedURI);
        int at = authority.lastIndexOf("@");
        return at > 0 ? authority.substring(at + 1) : authority;
    }

    public String getEscapedNetPathQuery() {
        return GenericURI.getEscapedNetPathQuery(this.URI);
    }

    public static String getEscapedNetPathQuery(String escapedURI) {
        int from = escapedURI.indexOf("//");
        int to = escapedURI.length();
        if (escapedURI.lastIndexOf("#") > from) {
            to = escapedURI.lastIndexOf("#");
        }
        return from >= 0 ? escapedURI.substring(from, to) : null;
    }

    public String getEscapedPath() {
        return GenericURI.getEscapedPath(this.URI);
    }

    public static String getEscapedPath(String escapedURI) {
        int at = escapedURI.indexOf("//");
        int from = escapedURI.indexOf("/", at >= 0 ? at + 2 : 0);
        int to = escapedURI.length();
        if (escapedURI.lastIndexOf("?") > from) {
            to = escapedURI.lastIndexOf("?");
        }
        if (escapedURI.lastIndexOf("#") > from && escapedURI.lastIndexOf("#") < to) {
            to = escapedURI.lastIndexOf("#");
        }
        return from >= 0 ? escapedURI.substring(from, to) : "/";
    }

    public String getEscapedPathQuery() {
        return GenericURI.getEscapedPathQuery(this.URI);
    }

    public static String getEscapedPathQuery(String escapedURI) {
        int at = escapedURI.indexOf("//");
        int from = escapedURI.indexOf("/", at >= 0 ? at + 2 : 0);
        int to = escapedURI.length();
        if (escapedURI.lastIndexOf("#") > from) {
            to = escapedURI.lastIndexOf("#");
        }
        return from >= 0 ? escapedURI.substring(from, to) : "/";
    }

    public String getEscapedQuery() throws MalformedURLException {
        return GenericURI.getEscapedQuery(this.URI);
    }

    public static String getEscapedQuery(String escapedURI) throws MalformedURLException {
        int at = escapedURI.indexOf("//");
        int n = at = at > 0 ? escapedURI.indexOf("/", at + 2) : escapedURI.indexOf("/");
        if (at > 0) {
            int from = escapedURI.lastIndexOf("?", at) > 0 ? escapedURI.lastIndexOf("?") + 1 : -1;
            int to = escapedURI.length();
            if (escapedURI.lastIndexOf("#", at) > at && escapedURI.lastIndexOf("#", at) < to) {
                to = escapedURI.lastIndexOf("#");
            }
            return from > 0 ? escapedURI.substring(from, to) : null;
        }
        throw new MalformedURLException("Need to have the path part");
    }

    public String getEscapedScheme() throws MalformedURLException {
        return this.getEscapedScheme(this.URI);
    }

    public String getEscapedScheme(String escapedURI) throws MalformedURLException {
        return GenericURI.getEscapedScheme(escapedURI, this.defaultScheme);
    }

    public static String getEscapedScheme(String escapedURI, String defaultScheme) throws MalformedURLException {
        int at = escapedURI.indexOf("://");
        if (at > 0) {
            return escapedURI.substring(0, at);
        }
        if (defaultScheme == null) {
            throw new MalformedURLException("No default scheme: " + escapedURI);
        }
        return defaultScheme;
    }

    public String getEscapedURI() {
        return this.URI;
    }

    public String getFragment() throws MalformedURLException {
        return GenericURI.getFragment(this.URI);
    }

    public static String getFragment(String escapedURI) throws MalformedURLException {
        return URIUtil.unescape(GenericURI.getEscapedFragment(escapedURI));
    }

    public String getHost() throws MalformedURLException {
        return GenericURI.getHost(this.URI);
    }

    public static String getHost(String escapedURI) throws MalformedURLException {
        return URIUtil.unescape(GenericURI.getEscapedHost(escapedURI));
    }

    public String getHostPort() throws MalformedURLException {
        return GenericURI.getHostPort(this.URI);
    }

    public static String getHostPort(String escapedURI) throws MalformedURLException {
        return URIUtil.unescape(GenericURI.getEscapedHostPort(escapedURI));
    }

    public String getNetPathQuery() {
        return GenericURI.getNetPathQuery(this.URI);
    }

    public static String getNetPathQuery(String escapedURI) {
        return URIUtil.unescape(GenericURI.getEscapedNetPathQuery(escapedURI));
    }

    public String getPath() {
        return GenericURI.getPath(this.URI);
    }

    public static String getPath(String escapedURI) {
        return URIUtil.unescape(GenericURI.getEscapedPath(escapedURI));
    }

    public String getPathQuery() {
        return GenericURI.getPathQuery(this.URI);
    }

    public static String getPathQuery(String escapedURI) {
        return URIUtil.unescape(GenericURI.getEscapedPathQuery(escapedURI));
    }

    public int getPort() throws MalformedURLException {
        return this.getPort(this.URI);
    }

    public int getPort(String escapedURI) throws MalformedURLException {
        return GenericURI.getPort(escapedURI, this.defaultPort);
    }

    public static int getPort(String escapedURI, int defaultPort) throws MalformedURLException {
        String hostPort = GenericURI.getEscapedHostPort(escapedURI);
        int at = hostPort.lastIndexOf(":");
        if (at > 0) {
            String port = URIUtil.unescape(hostPort.substring(at + 1));
            try {
                return port.equals("") ? defaultPort : Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        if (defaultPort == -1) {
            throw new MalformedURLException("No default port: " + escapedURI);
        }
        return defaultPort;
    }

    public String getQuery() throws MalformedURLException {
        return GenericURI.getQuery(this.URI);
    }

    public static String getQuery(String escapedURI) throws MalformedURLException {
        return URIUtil.unescape(GenericURI.getEscapedQuery(escapedURI));
    }

    public String getScheme() throws MalformedURLException {
        return this.getScheme(this.URI);
    }

    public String getScheme(String escapedURI) throws MalformedURLException {
        return GenericURI.getScheme(escapedURI, this.defaultScheme);
    }

    public static String getScheme(String escapedURI, String defaultScheme) throws MalformedURLException {
        return URIUtil.unescape(GenericURI.getEscapedScheme(escapedURI, defaultScheme));
    }

    public String getURI() {
        return URIUtil.unescape(this.URI);
    }

    protected void setDefaultPort(int port) {
        this.defaultPort = port;
    }

    protected void setDefaultScheme(String scheme) {
        this.defaultScheme = scheme.toLowerCase();
    }

    protected void setEscapedURI(String escapedURI) {
        this.URI = escapedURI;
    }

    public void setPath(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.URI = String.valueOf(this.getEscapedScheme()) + "://" + this.getEscapedAuthority() + URIUtil.escape(path, URIUtil.pathReserved());
    }

    public String toExternalForm() {
        return this.getEscapedURI();
    }

    public String toString() {
        return this.getEscapedURI();
    }
}

