/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractXAService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;

public abstract class J2EEStore
extends AbstractXAService {
    private static final int TX_IDLE = 0;
    private static final int TX_PREPARED = 1;
    private static final int TX_SUSPENDED = 1;
    private static final int CACHE_SIZE = 200;
    protected DataSource ds;
    protected String datasource;
    private Hashtable connectionMap = new Hashtable();
    private static Hashtable uriIdLookup = new Hashtable(200);
    private static Hashtable uriLookup = new Hashtable(200);
    private static Connection globalConnection;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.getLogger().log("commit() for thread " + Thread.currentThread() + ", removing from map", this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.remove(Thread.currentThread());
        if (id == null) {
            this.getLogger().log("Error committing: no transaction associated with current thread", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (!onePhase && id.status != 1) {
            throw new XAException(-6);
        }
        if (onePhase && id.status != 0 && id.status != 1) {
            throw new XAException(-6);
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log("commit(): No connection in connectionMap for id \"" + id + "\"", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
        }
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        this.getLogger().log("Trying connect to data source", this.LOG_CHANNEL, 7);
        try {
            globalConnection = this.ds.getConnection();
        }
        catch (SQLException sQLException) {
            throw new ServiceConnectionFailedException((Service)this, "Couldn't get global connection");
        }
        this.getLogger().log("Done connecting to database. The global connection is " + globalConnection, this.LOG_CHANNEL, 7);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        try {
            globalConnection.close();
        }
        catch (SQLException e) {
            this.getLogger().log("Failed to close special global connection: " + e.getMessage(), this.LOG_CHANNEL, 2);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.getLogger().log("end() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (flags == 0x2000000) {
            id.status = 1;
        }
        if (flags == 0x20000000) {
            id.rollbackOnly = true;
        }
    }

    public void forget(Xid xid) throws XAException {
        this.getLogger().log("forget() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null || id.xid == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        try {
            id.connection.close();
        }
        catch (SQLException sQLException) {
            this.getLogger().log("Couldn't close connection.", this.LOG_CHANNEL, 2);
        }
        this.getLogger().log("forget(): removing from map: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        this.connectionMap.remove(Thread.currentThread());
    }

    protected Connection getCurrentConnection() {
        this.getLogger().log("Getting current connection for thread " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null) {
            this.getLogger().log("No id for current thread - called outside transaction?", this.LOG_CHANNEL, 7);
            return globalConnection;
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log("No connection for current id - shouldn't be possible", this.LOG_CHANNEL, 2);
            return globalConnection;
        }
        this.getLogger().log("Returning current valid connection from map", this.LOG_CHANNEL, 7);
        return conn;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    protected String getUri(long uriId) throws SQLException {
        StringBuffer buf;
        Connection connection;
        Statement stmt;
        ResultSet rslt;
        Long uriIdLong = new Long(uriId);
        String uri = (String)uriLookup.get(uriIdLong);
        if (uri == null && (rslt = (stmt = (connection = this.getCurrentConnection()).createStatement()).executeQuery((buf = new StringBuffer("SELECT URI_STRING FROM URI WHERE URI_ID = ").append(uriId)).toString())).next()) {
            uri = rslt.getString("URI_STRING");
            if (uriLookup.size() == 200) {
                uriLookup.clear();
                uriIdLookup.clear();
            }
            rslt.close();
            uriLookup.put(uriIdLong, uri);
            uriIdLookup.put(uri, uriIdLong);
        }
        return uri;
    }

    protected long getUriId(String uri) throws SQLException {
        StringBuffer buf;
        Connection connection;
        Statement stmt;
        ResultSet rs;
        Long uriIdLong = (Long)uriIdLookup.get(uri);
        if (uriIdLong == null && (rs = (stmt = (connection = this.getCurrentConnection()).createStatement()).executeQuery((buf = new StringBuffer("SELECT URI_ID FROM URI ").append("WHERE URI_STRING = '").append(uri).append("'")).toString())).next()) {
            long uriId = rs.getLong("URI_ID");
            if (uriIdLookup.size() == 200) {
                uriIdLookup.clear();
                uriLookup.clear();
            }
            rs.close();
            uriIdLong = new Long(uriId);
            uriIdLookup.put(uri, uriIdLong);
            uriLookup.put(uriIdLong, uri);
        }
        return uriIdLong != null ? uriIdLong : 0L;
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            token.getLogger().log("Retrieving datasource '" + this.datasource + "'", this.LOG_CHANNEL, 6);
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.ds = (DataSource)envCtx.lookup(this.datasource);
        }
        catch (Exception e) {
            token.getLogger().log("Retrieving data source instance '" + this.datasource + "' failed: " + e.getMessage(), this.LOG_CHANNEL, 2);
            token.getLogger().log(e.toString(), this.LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        if (this.ds == null) {
            throw new ServiceInitializationFailedException((Service)this, "Data source not found");
        }
    }

    public boolean isConnected() {
        try {
            return this.ds != null && globalConnection != null && !globalConnection.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares == null) {
            return false;
        }
        return this == xares;
    }

    public int prepare(Xid xid) throws XAException {
        this.getLogger().log("prepare() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (id.status != 0 && id.status != 1) {
            throw new XAException(-6);
        }
        if (id.rollbackOnly) {
            throw new XAException(100);
        }
        id.status = 1;
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        this.getLogger().log("recover() for thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        if (id != null && id.status == 1) {
            Xid[] xids = new Xid[]{id.xid};
            return xids;
        }
        return new Xid[0];
    }

    protected void removeUri(String uri) throws SQLException {
        long uriId = this.getUriId(uri);
        if (uriId != 0L) {
            Connection conn = this.getCurrentConnection();
            Statement stmt = conn.createStatement();
            StringBuffer buf = new StringBuffer("DELETE FROM URI WHERE URI_ID = ").append(uriId);
            stmt.execute(buf.toString());
            stmt.close();
            uriIdLookup.remove(uri);
            uriLookup.remove(new Long(uriId));
        }
    }

    public synchronized void reset() throws ServiceResetFailedException {
    }

    public void rollback(Xid xid) throws XAException {
        this.getLogger().log("rollback() for thread " + Thread.currentThread() + ", removing from map", this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.remove(Thread.currentThread());
        if (id == null) {
            this.getLogger().log("No transaction associated with current thread, can't rollback", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        Connection conn = id.connection;
        if (conn == null) {
            this.getLogger().log("rollback(): No connection in connectionMap for id \"" + id + "\"", this.LOG_CHANNEL, 2);
            throw new XAException(-4);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
        }
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        String value = (String)parameters.get("datasource");
        if (value == null) {
            throw new ServiceParameterMissingException(this, "datasource");
        }
        this.datasource = value;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    protected void setUriId(String uri) throws SQLException {
        if (this.getUriId(uri) == 0L) {
            Connection connection = this.getCurrentConnection();
            Statement stmt = connection.createStatement();
            StringBuffer buf = new StringBuffer("INSERT INTO URI (URI_STRING) VALUES ('").append(uri).append("')");
            stmt.execute(buf.toString());
            stmt.close();
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        this.getLogger().log("start(): beginning transaction with xid " + xid, this.LOG_CHANNEL, 7);
        TransactionId id = (TransactionId)this.connectionMap.get(Thread.currentThread());
        switch (flags) {
            case 0: {
                if (id != null) {
                    throw new XAException(-5);
                }
                id = new TransactionId(xid, 0);
                this.getLogger().log("start(): adding to map for " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                this.connectionMap.put(Thread.currentThread(), id);
                break;
            }
            case 0x200000: {
                this.getLogger().log("TMJOIN for transaction in thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                if (id != null) break;
                throw new XAException(-4);
            }
            case 0x8000000: {
                this.getLogger().log("TMRESUME for transaction in thread: " + Thread.currentThread(), this.LOG_CHANNEL, 7);
                if (id == null) {
                    throw new XAException(-4);
                }
                if (id.status != 1) {
                    throw new XAException(-5);
                }
                id.status = 0;
                break;
            }
        }
    }

    private class TransactionId {
        Xid xid;
        int status;
        boolean rollbackOnly;
        Connection connection;

        TransactionId(Xid xid, int status) {
            this.xid = xid;
            this.status = status;
            this.rollbackOnly = false;
            try {
                this.connection = J2EEStore.this.ds.getConnection();
                if (this.connection == null) {
                    this.connection = globalConnection;
                    return;
                }
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
            }
            catch (SQLException sQLException) {
                this.connection = globalConnection;
            }
        }
    }
}

