/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.AbstractSimpleService;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Scope;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Messages;

public abstract class AbstractStore
extends AbstractSimpleService
implements Store {
    protected String defaultStore = "slidestore.reference.DefaultStore";
    protected Service defaultStoreInstance;
    protected NodeStore nodeStore;
    protected SecurityStore securityStore;
    protected LockStore lockStore;
    protected RevisionDescriptorsStore revisionDescriptorsStore;
    protected RevisionDescriptorStore revisionDescriptorStore;
    protected ContentStore contentStore;
    protected Service[] resourceManagers = new Service[0];
    private String name;
    protected Hashtable parameters = null;
    static /* synthetic */ Class class$org$apache$slide$store$AbstractStore;

    protected void addResourceManager(Service service) {
        if (service == null) {
            return;
        }
        int i = 0;
        while (i < this.resourceManagers.length) {
            try {
                if (this.resourceManagers[i].isSameRM(service)) {
                    return;
                }
            }
            catch (XAException xAException) {}
            ++i;
        }
        Service[] results = new Service[this.resourceManagers.length + 1];
        System.arraycopy(this.resourceManagers, 0, results, 0, this.resourceManagers.length);
        results[this.resourceManagers.length] = service;
        this.resourceManagers = results;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
    }

    public void connect() throws ServiceConnectionFailedException {
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].connect();
            ++i;
        }
    }

    public void connect(CredentialsToken crdtoken) throws ServiceConnectionFailedException {
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].connect(crdtoken);
            ++i;
        }
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        ObjectNode tempObject = object.cloneObject();
        tempObject.validate(uri.toString());
        this.enlist(this.nodeStore);
        try {
            this.nodeStore.createObject(uri, tempObject);
        }
        catch (ServiceAccessException e) {
            this.delist(this.nodeStore, false);
            throw e;
        }
        catch (ObjectAlreadyExistsException e) {
            this.delist(this.nodeStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.nodeStore, false);
            throw new ServiceAccessException((Service)this.nodeStore, t);
        }
        this.delist(this.nodeStore);
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        revisionDescriptor.validate();
        revisionContent.validate();
        this.enlist(this.contentStore);
        try {
            this.contentStore.createRevisionContent(uri, revisionDescriptor, revisionContent);
        }
        catch (ServiceAccessException e) {
            this.delist(this.contentStore, false);
            throw e;
        }
        catch (RevisionAlreadyExistException e) {
            this.delist(this.contentStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.contentStore, false);
            throw new ServiceAccessException((Service)this.contentStore, t);
        }
        this.delist(this.contentStore);
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        revisionDescriptor.validate();
        this.enlist(this.revisionDescriptorStore);
        try {
            this.revisionDescriptorStore.createRevisionDescriptor(uri, revisionDescriptor);
        }
        catch (ServiceAccessException e) {
            this.delist(this.revisionDescriptorStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.revisionDescriptorStore, false);
            throw new ServiceAccessException((Service)this.revisionDescriptorStore, t);
        }
        this.delist(this.revisionDescriptorStore);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        revisionDescriptors.validate(uri.toString());
        this.enlist(this.revisionDescriptorsStore);
        try {
            this.revisionDescriptorsStore.createRevisionDescriptors(uri, revisionDescriptors);
        }
        catch (ServiceAccessException e) {
            this.delist(this.revisionDescriptorsStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.revisionDescriptorsStore, false);
            throw new ServiceAccessException((Service)this.revisionDescriptorsStore, t);
        }
        this.delist(this.revisionDescriptorsStore);
    }

    protected void delist(Service service) throws ServiceAccessException {
        this.delist(service, true);
    }

    protected void delist(Service service, boolean success) throws ServiceAccessException {
        try {
            Transaction transaction = this.namespace.getTransactionManager().getTransaction();
            if (transaction == null) {
                return;
            }
            if (success) {
                transaction.delistResource((XAResource)service, 0x2000000);
                if (this.getLogger().isEnabled(this.LOG_CHANNEL, 7)) {
                    String logMessage = Messages.format(String.valueOf((class$org$apache$slide$store$AbstractStore != null ? class$org$apache$slide$store$AbstractStore : (class$org$apache$slide$store$AbstractStore = AbstractStore.class$("org.apache.slide.store.AbstractStore"))).getName()) + ".delist", service);
                    this.getLogger().log(logMessage, this.LOG_CHANNEL, 7);
                }
            } else {
                transaction.delistResource((XAResource)service, 0x20000000);
                String logMessage = Messages.format(String.valueOf((class$org$apache$slide$store$AbstractStore != null ? class$org$apache$slide$store$AbstractStore : (class$org$apache$slide$store$AbstractStore = AbstractStore.class$("org.apache.slide.store.AbstractStore"))).getName()) + ".delistFail", service);
                this.getLogger().log(logMessage, this.LOG_CHANNEL, 6);
            }
        }
        catch (Exception e) {
            throw new ServiceAccessException((Service)this, e.getMessage());
        }
    }

    protected void delist(boolean success) throws ServiceAccessException {
        this.delist(this, success);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].disconnect();
            ++i;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        super.end(xid, flags);
    }

    protected void enlist() throws ServiceAccessException {
        this.enlist(this);
    }

    protected void enlist(Service service) throws ServiceAccessException {
        boolean enlisted = false;
        int nbTry = 0;
        while (!enlisted && nbTry++ < 20) {
            Transaction transaction = null;
            try {
                transaction = this.namespace.getTransactionManager().getTransaction();
            }
            catch (Exception exception) {}
            if (transaction == null) {
                this.getLogger().log("WARNING: No active transaction", 4);
                return;
            }
            try {
                enlisted = transaction.enlistResource((XAResource)service);
            }
            catch (Exception e) {
                this.setRollbackOnly();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            if (enlisted) continue;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!enlisted) {
            String exMessage = Messages.format(String.valueOf((class$org$apache$slide$store$AbstractStore != null ? class$org$apache$slide$store$AbstractStore : (class$org$apache$slide$store$AbstractStore = AbstractStore.class$("org.apache.slide.store.AbstractStore"))).getName()) + ".enlistFail", service);
            this.setRollbackOnly();
            throw new ServiceAccessException((Service)this, exMessage);
        }
        if (this.getLogger().isEnabled(this.LOG_CHANNEL, 7)) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$store$AbstractStore != null ? class$org$apache$slide$store$AbstractStore : (class$org$apache$slide$store$AbstractStore = AbstractStore.class$("org.apache.slide.store.AbstractStore"))).getName()) + ".enlist", service);
            this.getLogger().log(logMessage, this.LOG_CHANNEL, 7);
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        if (this.isForceStoreEnlistment(uri)) {
            this.enlist(this.lockStore);
            Enumeration locks = null;
            try {
                locks = this.lockStore.enumerateLocks(uri);
            }
            catch (ServiceAccessException e) {
                this.delist(this.lockStore, false);
                throw e;
            }
            catch (Throwable t) {
                this.delist(this.lockStore, false);
                throw new ServiceAccessException((Service)this.lockStore, t);
            }
            this.delist(this.lockStore);
            return locks;
        }
        try {
            return this.lockStore.enumerateLocks(uri);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServiceAccessException((Service)this.lockStore, t);
        }
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        if (this.isForceStoreEnlistment(uri)) {
            this.enlist(this.securityStore);
            Enumeration permissions = null;
            try {
                permissions = this.securityStore.enumeratePermissions(uri);
            }
            catch (ServiceAccessException e) {
                this.delist(this.securityStore, false);
                throw e;
            }
            catch (Throwable t) {
                this.delist(this.securityStore, false);
                throw new ServiceAccessException((Service)this.securityStore, t);
            }
            this.delist(this.securityStore);
            return permissions;
        }
        try {
            return this.securityStore.enumeratePermissions(uri);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServiceAccessException((Service)this.securityStore, t);
        }
    }

    public void forget(Xid xid) throws XAException {
        super.forget(xid);
    }

    protected Service getDefaultStoreInstance() {
        if (this.defaultStoreInstance != null) {
            return this.defaultStoreInstance;
        }
        try {
            this.defaultStoreInstance = (Service)Class.forName(this.defaultStore).newInstance();
            this.defaultStoreInstance.setParameters(this.parameters);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.defaultStoreInstance;
    }

    public String getName() {
        return this.name;
    }

    public Object getParameter(Object key) {
        return this.parameters.get(key);
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        NodePermission tempPermission = permission.cloneObject();
        tempPermission.validate(uri.toString());
        this.enlist(this.securityStore);
        try {
            this.securityStore.grantPermission(uri, tempPermission);
        }
        catch (ServiceAccessException e) {
            this.delist(this.securityStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.securityStore, false);
            throw new ServiceAccessException((Service)this.securityStore, t);
        }
        this.delist(this.securityStore);
    }

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].initialize(token);
            ++i;
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        int i = 0;
        while (i < this.resourceManagers.length) {
            if (!this.resourceManagers[i].isConnected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isForceStoreEnlistment(Uri uri) {
        SlideToken token = uri.getToken();
        if (token == null) {
            return false;
        }
        return token.isForceStoreEnlistment();
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        lock.validate(uri.toString());
        this.enlist(this.lockStore);
        try {
            this.lockStore.killLock(uri, lock);
        }
        catch (ServiceAccessException e) {
            this.delist(this.lockStore, false);
            throw e;
        }
        catch (LockTokenNotFoundException e) {
            this.delist(this.lockStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.lockStore, false);
            throw new ServiceAccessException((Service)this.lockStore, t);
        }
        this.delist(this.lockStore);
    }

    public int prepare(Xid xid) throws XAException {
        return super.prepare(xid);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        lock.validate(uri.toString());
        this.enlist(this.lockStore);
        try {
            this.lockStore.putLock(uri, lock);
        }
        catch (ServiceAccessException e) {
            this.delist(this.lockStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.lockStore, false);
            throw new ServiceAccessException((Service)this.lockStore, t);
        }
        this.delist(this.lockStore);
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        lock.validate(uri.toString());
        this.enlist(this.lockStore);
        try {
            this.lockStore.removeLock(uri, lock);
        }
        catch (ServiceAccessException e) {
            this.delist(this.lockStore, false);
            throw e;
        }
        catch (LockTokenNotFoundException e) {
            this.delist(this.lockStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.lockStore, false);
            throw new ServiceAccessException((Service)this.lockStore, t);
        }
        this.delist(this.lockStore);
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        object.validate(uri.toString());
        this.enlist(this.nodeStore);
        try {
            this.nodeStore.removeObject(uri, object);
        }
        catch (ServiceAccessException e) {
            this.delist(this.nodeStore, false);
            throw e;
        }
        catch (ObjectNotFoundException e) {
            this.delist(this.nodeStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.nodeStore, false);
            throw new ServiceAccessException((Service)this.nodeStore, t);
        }
        this.delist(this.nodeStore);
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        revisionDescriptor.validate();
        this.enlist(this.contentStore);
        try {
            this.contentStore.removeRevisionContent(uri, revisionDescriptor);
        }
        catch (ServiceAccessException e) {
            this.delist(this.contentStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.contentStore, false);
            throw new ServiceAccessException((Service)this.contentStore, t);
        }
        this.delist(this.contentStore);
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        number.validate();
        this.enlist(this.revisionDescriptorStore);
        try {
            this.revisionDescriptorStore.removeRevisionDescriptor(uri, number);
        }
        catch (ServiceAccessException e) {
            this.delist(this.revisionDescriptorStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.revisionDescriptorStore, false);
            throw new ServiceAccessException((Service)this.revisionDescriptorStore, t);
        }
        this.delist(this.revisionDescriptorStore);
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        this.enlist(this.revisionDescriptorsStore);
        try {
            this.revisionDescriptorsStore.removeRevisionDescriptors(uri);
        }
        catch (ServiceAccessException e) {
            this.delist(this.revisionDescriptorsStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.revisionDescriptorsStore, false);
            throw new ServiceAccessException((Service)this.revisionDescriptorsStore, t);
        }
        this.delist(this.revisionDescriptorsStore);
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        lock.validate(uri.toString());
        this.enlist(this.lockStore);
        try {
            this.lockStore.renewLock(uri, lock);
        }
        catch (ServiceAccessException e) {
            this.delist(this.lockStore, false);
            throw e;
        }
        catch (LockTokenNotFoundException e) {
            this.delist(this.lockStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.lockStore, false);
            throw new ServiceAccessException((Service)this.lockStore, t);
        }
        this.delist(this.lockStore);
    }

    public void reset() throws ServiceResetFailedException {
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].reset();
            ++i;
        }
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode objectNode = null;
        if (this.isForceStoreEnlistment(uri)) {
            this.enlist(this.nodeStore);
            try {
                objectNode = this.nodeStore.retrieveObject(uri);
            }
            catch (ServiceAccessException e) {
                this.delist(this.nodeStore, false);
                throw e;
            }
            catch (ObjectNotFoundException e) {
                this.delist(this.nodeStore);
                throw e;
            }
            catch (Throwable t) {
                this.delist(this.nodeStore, false);
                throw new ServiceAccessException((Service)this.nodeStore, t);
            }
            this.delist(this.nodeStore);
        } else {
            try {
                objectNode = this.nodeStore.retrieveObject(uri);
            }
            catch (ServiceAccessException e) {
                throw e;
            }
            catch (ObjectNotFoundException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ServiceAccessException((Service)this.nodeStore, t);
            }
        }
        objectNode.validate(uri.toString());
        return objectNode;
    }

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent revisionContent = null;
        if (this.isForceStoreEnlistment(uri)) {
            this.enlist(this.contentStore);
            try {
                revisionContent = this.contentStore.retrieveRevisionContent(uri, revisionDescriptor);
            }
            catch (ServiceAccessException e) {
                this.delist(this.contentStore, false);
                throw e;
            }
            catch (RevisionNotFoundException e) {
                this.delist(this.contentStore);
                throw e;
            }
            catch (Throwable t) {
                this.delist(this.contentStore, false);
                throw new ServiceAccessException((Service)this.contentStore, t);
            }
            this.delist(this.contentStore);
        } else {
            try {
                revisionContent = this.contentStore.retrieveRevisionContent(uri, revisionDescriptor);
            }
            catch (ServiceAccessException e) {
                throw e;
            }
            catch (RevisionNotFoundException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ServiceAccessException((Service)this.contentStore, t);
            }
        }
        revisionContent.validate();
        return revisionContent;
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptor revisionDescriptor = null;
        if (this.isForceStoreEnlistment(uri)) {
            this.enlist(this.revisionDescriptorStore);
            try {
                revisionDescriptor = this.revisionDescriptorStore.retrieveRevisionDescriptor(uri, revisionNumber);
            }
            catch (ServiceAccessException e) {
                this.delist(this.revisionDescriptorStore, false);
                throw e;
            }
            catch (RevisionDescriptorNotFoundException e) {
                this.delist(this.revisionDescriptorStore);
                throw e;
            }
            catch (Throwable t) {
                this.delist(this.revisionDescriptorStore, false);
                throw new ServiceAccessException((Service)this.revisionDescriptorStore, t);
            }
            this.delist(this.revisionDescriptorStore);
        } else {
            try {
                revisionDescriptor = this.revisionDescriptorStore.retrieveRevisionDescriptor(uri, revisionNumber);
            }
            catch (ServiceAccessException e) {
                throw e;
            }
            catch (RevisionDescriptorNotFoundException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ServiceAccessException((Service)this.revisionDescriptorStore, t);
            }
        }
        revisionDescriptor.validate();
        return revisionDescriptor;
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptors revisionDescriptors = null;
        if (this.isForceStoreEnlistment(uri)) {
            this.enlist(this.revisionDescriptorsStore);
            try {
                revisionDescriptors = this.revisionDescriptorsStore.retrieveRevisionDescriptors(uri);
            }
            catch (ServiceAccessException e) {
                this.delist(this.revisionDescriptorsStore, false);
                throw e;
            }
            catch (RevisionDescriptorNotFoundException e) {
                this.delist(this.revisionDescriptorsStore);
                throw e;
            }
            catch (Throwable t) {
                this.delist(this.revisionDescriptorsStore, false);
                throw new ServiceAccessException((Service)this.revisionDescriptorsStore, t);
            }
            this.delist(this.revisionDescriptorsStore);
        } else {
            try {
                revisionDescriptors = this.revisionDescriptorsStore.retrieveRevisionDescriptors(uri);
            }
            catch (ServiceAccessException e) {
                throw e;
            }
            catch (RevisionDescriptorNotFoundException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ServiceAccessException((Service)this.revisionDescriptorsStore, t);
            }
        }
        revisionDescriptors.validate(uri.toString());
        return revisionDescriptors;
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        permission.validate(uri.toString());
        this.enlist(this.securityStore);
        try {
            this.securityStore.revokePermission(uri, permission);
        }
        catch (ServiceAccessException e) {
            this.delist(this.securityStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.securityStore, false);
            throw new ServiceAccessException((Service)this.securityStore, t);
        }
        this.delist(this.securityStore);
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        this.enlist(this.securityStore);
        try {
            this.securityStore.revokePermissions(uri);
        }
        catch (ServiceAccessException e) {
            this.delist(this.securityStore, false);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.securityStore, false);
            throw new ServiceAccessException((Service)this.securityStore, t);
        }
        this.delist(this.securityStore);
    }

    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
    }

    public void setContentStore(ContentStore contentStore) {
        this.contentStore = contentStore != null ? contentStore : (ContentStore)this.getDefaultStoreInstance();
        this.addResourceManager(this.contentStore);
    }

    public void setLockStore(LockStore lockStore) {
        this.lockStore = lockStore != null ? lockStore : (LockStore)this.getDefaultStoreInstance();
        this.addResourceManager(this.lockStore);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(Namespace namespace) {
        super.setNamespace(namespace);
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].setNamespace(namespace);
            ++i;
        }
    }

    public void setNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore != null ? nodeStore : (NodeStore)this.getDefaultStoreInstance();
        this.addResourceManager(this.nodeStore);
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.parameters = parameters;
    }

    public void setRevisionDescriptorStore(RevisionDescriptorStore revisionDescriptorStore) {
        this.revisionDescriptorStore = revisionDescriptorStore != null ? revisionDescriptorStore : (RevisionDescriptorStore)this.getDefaultStoreInstance();
        this.addResourceManager(this.revisionDescriptorStore);
    }

    public void setRevisionDescriptorsStore(RevisionDescriptorsStore revisionDescriptorsStore) {
        this.revisionDescriptorsStore = revisionDescriptorsStore != null ? revisionDescriptorsStore : (RevisionDescriptorsStore)this.getDefaultStoreInstance();
        this.addResourceManager(this.revisionDescriptorsStore);
    }

    protected void setRollbackOnly() {
        try {
            Transaction transaction = this.namespace.getTransactionManager().getTransaction();
            if (transaction == null) {
                return;
            }
            transaction.setRollbackOnly();
        }
        catch (Exception exception) {}
    }

    public void setScope(Scope scope) {
        super.setScope(scope);
        int i = 0;
        while (i < this.resourceManagers.length) {
            this.resourceManagers[i].setScope(scope);
            ++i;
        }
    }

    public void setSecurityStore(SecurityStore securityStore) {
        this.securityStore = securityStore != null ? securityStore : (SecurityStore)this.getDefaultStoreInstance();
        this.addResourceManager(this.securityStore);
    }

    public void start(Xid xid, int flags) throws XAException {
        super.start(xid, flags);
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode tempObject = object.cloneObject();
        tempObject.validate(uri.toString());
        this.enlist(this.nodeStore);
        try {
            this.nodeStore.storeObject(uri, tempObject);
        }
        catch (ServiceAccessException e) {
            this.delist(this.nodeStore, false);
            throw e;
        }
        catch (ObjectNotFoundException e) {
            this.delist(this.nodeStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.nodeStore, false);
            throw new ServiceAccessException((Service)this.contentStore, t);
        }
        this.delist(this.nodeStore);
    }

    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        revisionDescriptor.validate();
        revisionContent.validate();
        this.enlist(this.contentStore);
        try {
            this.contentStore.storeRevisionContent(uri, revisionDescriptor, revisionContent);
        }
        catch (ServiceAccessException e) {
            this.delist(this.contentStore, false);
            throw e;
        }
        catch (RevisionNotFoundException e) {
            this.delist(this.contentStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.contentStore, false);
            throw new ServiceAccessException((Service)this.contentStore, t);
        }
        this.delist(this.contentStore);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        revisionDescriptor.validate();
        this.enlist(this.revisionDescriptorStore);
        try {
            this.revisionDescriptorStore.storeRevisionDescriptor(uri, revisionDescriptor);
        }
        catch (ServiceAccessException e) {
            this.delist(this.revisionDescriptorStore, false);
            throw e;
        }
        catch (RevisionDescriptorNotFoundException e) {
            this.delist(this.revisionDescriptorStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.revisionDescriptorStore, false);
            throw new ServiceAccessException((Service)this.revisionDescriptorStore, t);
        }
        this.delist(this.revisionDescriptorStore);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        revisionDescriptors.validate(uri.toString());
        this.enlist(this.revisionDescriptorsStore);
        try {
            this.revisionDescriptorsStore.storeRevisionDescriptors(uri, revisionDescriptors);
        }
        catch (ServiceAccessException e) {
            this.delist(this.revisionDescriptorsStore, false);
            throw e;
        }
        catch (RevisionDescriptorNotFoundException e) {
            this.delist(this.revisionDescriptorsStore);
            throw e;
        }
        catch (Throwable t) {
            this.delist(this.revisionDescriptorsStore, false);
            throw new ServiceAccessException((Service)this.revisionDescriptorsStore, t);
        }
        this.delist(this.revisionDescriptorsStore);
    }
}

