/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.common.Uri;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.GroupNode;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;

public final class SecurityImpl
implements Security {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Hashtable rolesCache;
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public SecurityImpl(Namespace namespace, NamespaceConfig namespaceConfig) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.rolesCache = new Hashtable();
    }

    public void checkCredentials(SlideToken token, ObjectNode object, ActionNode action) throws ServiceAccessException, AccessDeniedException {
        token = new SlideTokenWrapper(token, false);
        try {
            if (Configuration.useIntegratedSecurity()) {
                Uri objectUri = this.namespace.getUri(token, object.getUri());
                ObjectNode realObject = objectUri.getStore().retrieveObject(objectUri);
                SubjectNode subject = (SubjectNode)this.getPrincipal(token);
                this.checkPermission(realObject, subject, action);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new AccessDeniedException(object.getUri(), token.getCredentialsToken().getPublicCredentials(), action.getUri());
        }
    }

    public void checkPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, AccessDeniedException, ObjectNotFoundException {
        if (!this.hasPermission(object, subject, action)) {
            throw new AccessDeniedException(object.getUri(), subject.getUri(), action.getUri());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void denyPermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        if (!permission.isNegative()) {
            permission.setNegative(true);
        }
        this.grantPermission(token, permission);
    }

    public void denyPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        this.denyPermission(token, object, subject, action, true);
    }

    public void denyPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        NodePermission permission = new NodePermission(object, subject, action, inheritable, true);
        this.denyPermission(token, permission);
    }

    public Enumeration enumeratePermissions(SlideToken token, String object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, object);
        return objectUri.getStore().enumeratePermissions(objectUri);
    }

    public Enumeration enumeratePermissions(SlideToken token, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        return this.enumeratePermissions(token, object.getUri());
    }

    public ObjectNode getPrincipal(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        String principalPath = token.getCredentialsToken().getPublicCredentials();
        if (principalPath == null || principalPath.equals("")) {
            principalPath = this.namespaceConfig.getGuestPath();
        }
        Uri subjectUri = this.namespace.getUri(token, String.valueOf(this.namespaceConfig.getUsersPath()) + "/" + principalPath);
        try {
            return subjectUri.getStore().retrieveObject(subjectUri);
        }
        catch (ObjectNotFoundException e) {
            if (!this.namespaceConfig.isAutoCreateUsers()) {
                throw e;
            }
            try {
                Uri parentUri = subjectUri.getParentUri();
                ObjectNode parent = subjectUri.getStore().retrieveObject(parentUri);
                Enumeration childrenEnum = parent.enumerateChildren();
                Enumeration linksEnum = parent.enumerateLinks();
                Vector children = new Vector();
                while (childrenEnum.hasMoreElements()) {
                    children.addElement(childrenEnum.nextElement());
                }
                children.addElement(subjectUri.toString());
                Vector links = new Vector();
                while (linksEnum.hasMoreElements()) {
                    links.addElement(linksEnum.nextElement());
                }
                Class<?> objectClass = Class.forName(this.namespaceConfig.getAutoCreateUsersRole());
                Class[] types = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SecurityImpl.class$("java.lang.String"))};
                Object[] args = new Object[]{subjectUri.toString()};
                Constructor<?> constructor = objectClass.getConstructor(types);
                ObjectNode object = (ObjectNode)constructor.newInstance(args);
                subjectUri.getStore().createObject(subjectUri, object);
                Class[] types2 = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SecurityImpl.class$("java.lang.String")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = SecurityImpl.class$("java.util.Vector")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = SecurityImpl.class$("java.util.Vector"))};
                Object[] args2 = new Object[]{parentUri.toString(), children, links};
                constructor = parent.getClass().getConstructor(types2);
                object = (ObjectNode)constructor.newInstance(args2);
                parentUri.getStore().storeObject(parentUri, object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (InstantiationException instantiationException) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ObjectNotFoundException(subjectUri);
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                e.printStackTrace();
                throw new ObjectNotFoundException(subjectUri);
            }
        }
        return subjectUri.getStore().retrieveObject(subjectUri);
    }

    public Enumeration getRoles(SlideToken token) throws ServiceAccessException, ObjectNotFoundException {
        return this.getRoles(this.getPrincipal(token));
    }

    public Enumeration getRoles(ObjectNode object) {
        Vector<String> result = new Vector<String>();
        result.addElement("nobody");
        Class<?> currentObjectClass = object.getClass();
        while (!currentObjectClass.equals(class$org$apache$slide$structure$ObjectNode != null ? class$org$apache$slide$structure$ObjectNode : SecurityImpl.class$("org.apache.slide.structure.ObjectNode"))) {
            Class<?>[] interfaces = currentObjectClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                String className = interfaces[i].getName();
                String associatedName = this.namespaceConfig.getRoleMapping(className);
                if (associatedName != null) {
                    result.addElement(associatedName);
                } else {
                    result.addElement(className);
                }
                ++i;
            }
            if ((currentObjectClass = currentObjectClass.getSuperclass()) != null) continue;
            throw new IllegalStateException("Invalid node");
        }
        return result.elements();
    }

    public void grantPermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, permission.getObjectUri());
        ObjectNode object = objectUri.getStore().retrieveObject(objectUri);
        Enumeration permissions = this.enumeratePermissions(token, object);
        boolean alreadyPresent = false;
        while (permissions.hasMoreElements() && !alreadyPresent) {
            if (!permission.equals(permissions.nextElement())) continue;
            alreadyPresent = true;
        }
        if (!alreadyPresent) {
            this.checkCredentials(token, object, this.namespaceConfig.getGrantPermissionAction());
            objectUri.getStore().grantPermission(objectUri, permission);
        }
    }

    public void grantPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        this.grantPermission(token, object, subject, action, true);
    }

    public void grantPermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action, boolean inheritable) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        NodePermission permission = new NodePermission(object, subject, action, inheritable);
        this.grantPermission(token, permission);
    }

    public boolean hasPermission(ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException {
        boolean granted = false;
        boolean denied = false;
        boolean rootObjectReached = false;
        ObjectNode courObject = object;
        Uri subjectUri = this.namespace.getUri(subject.getUri());
        Uri actionUri = this.namespace.getUri(action.getUri());
        while (!(granted || denied || rootObjectReached)) {
            Uri courUri = this.namespace.getUri(courObject.getUri());
            Enumeration permissions = courUri.getStore().enumeratePermissions(courUri);
            while (permissions.hasMoreElements()) {
                boolean oldGranted = granted;
                boolean oldDenied = denied;
                NodePermission permission = (NodePermission)permissions.nextElement();
                String permissionSubject = permission.getSubjectUri();
                if (permissionSubject.equals("~")) {
                    boolean check = object.getUri().equals(subjectUri.toString());
                    if (permission.isInheritable()) {
                        String subjectUriString = subjectUri.toString();
                        if (!subjectUriString.endsWith("/")) {
                            subjectUriString = String.valueOf(subjectUriString) + "/";
                        }
                        check |= object.getUri().startsWith(subjectUriString);
                    }
                    granted = !permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                    denied = permission.isNegative() && check && actionUri.toString().startsWith(permission.getActionUri());
                } else if (permission.isInheritable() || permission.getObjectUri().equals(object.getUri())) {
                    if (permissionSubject.startsWith("/")) {
                        String permSubj = permission.getSubjectUri();
                        if (!permSubj.endsWith("/")) {
                            permSubj = String.valueOf(permSubj) + "/";
                        }
                        boolean match = subjectUri.toString().equals(permission.getSubjectUri()) || subjectUri.toString().startsWith(permSubj);
                        granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                        denied = permission.isNegative() && match;
                    } else if (permissionSubject.startsWith("+")) {
                        Uri permissionSubjectUri = this.namespace.getUri(permissionSubject.substring(1));
                        ObjectNode group = permissionSubjectUri.getStore().retrieveObject(permissionSubjectUri);
                        if (group instanceof GroupNode && group.hasChildren()) {
                            Enumeration groupMembers = group.enumerateChildren();
                            while (groupMembers.hasMoreElements()) {
                                oldGranted = granted;
                                oldDenied = denied;
                                Uri childUri = this.namespace.getUri((String)groupMembers.nextElement());
                                ObjectNode childNode = childUri.getStore().retrieveObject(childUri);
                                String childSubjectUri = childNode instanceof LinkNode ? ((LinkNode)childNode).getLinkedUri() : childNode.getUri();
                                String testUri = !childSubjectUri.endsWith("/") ? String.valueOf(childSubjectUri) + "/" : childSubjectUri;
                                boolean match = subjectUri.toString().equals(childSubjectUri) || subjectUri.toString().startsWith(testUri);
                                granted = !permission.isNegative() && (match &= actionUri.toString().startsWith(permission.getActionUri()));
                                denied = permission.isNegative() && match;
                                granted |= oldGranted;
                                denied |= oldDenied;
                            }
                        }
                    } else {
                        granted = !permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                        denied = permission.isNegative() && this.hasRole(subject, permissionSubject) && actionUri.toString().startsWith(permission.getActionUri());
                    }
                }
                granted |= oldGranted;
                denied |= oldDenied;
            }
            Uri parentUri = courUri.getParentUri();
            if (parentUri != null) {
                courObject = parentUri.getStore().retrieveObject(parentUri);
                continue;
            }
            rootObjectReached = true;
        }
        if (denied) {
            return false;
        }
        return granted;
    }

    public boolean hasRole(SlideToken token, String role) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode subject = this.getPrincipal(token);
        return this.hasRole(subject, role);
    }

    public boolean hasRole(ObjectNode object, String role) throws ServiceAccessException, ObjectNotFoundException {
        if (role.equals("nobody")) {
            return true;
        }
        String associatedRole = this.namespaceConfig.getRoleMapping(role);
        if (associatedRole != null && associatedRole.equals("nobody")) {
            return true;
        }
        Class<?> roleClass = (Class<?>)this.rolesCache.get(role);
        if (roleClass == null && associatedRole != null && (roleClass = (Class<?>)this.rolesCache.get(associatedRole)) == null) {
            try {
                roleClass = Class.forName(associatedRole);
                this.rolesCache.put(role, roleClass);
                this.rolesCache.put(associatedRole, roleClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (roleClass == null) {
            try {
                roleClass = Class.forName(role);
                this.rolesCache.put(role, roleClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (roleClass == null) {
            return false;
        }
        return roleClass.isInstance(object);
    }

    public void revokePermission(SlideToken token, NodePermission permission) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, permission.getObjectUri());
        ObjectNode object = objectUri.getStore().retrieveObject(objectUri);
        this.checkCredentials(token, object, this.namespaceConfig.getRevokePermissionAction());
        objectUri.getStore().revokePermission(objectUri, permission);
    }

    public void revokePermission(SlideToken token, ObjectNode object, SubjectNode subject, ActionNode action) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        this.checkCredentials(token, object, this.namespaceConfig.getRevokePermissionAction());
        NodePermission permission = new NodePermission(object, subject, action);
        Uri objectUri = this.namespace.getUri(token, object.getUri());
        objectUri.getStore().revokePermission(objectUri, permission);
    }

    public void setPermissions(SlideToken token, String object, Enumeration permissions) throws ServiceAccessException, ObjectNotFoundException, AccessDeniedException {
        Uri objectUri = this.namespace.getUri(token, object);
        ObjectNode objectNode = objectUri.getStore().retrieveObject(objectUri);
        this.checkCredentials(token, objectNode, this.namespaceConfig.getGrantPermissionAction());
        this.checkCredentials(token, objectNode, this.namespaceConfig.getRevokePermissionAction());
        objectUri.getStore().revokePermissions(objectUri);
        while (permissions.hasMoreElements()) {
            NodePermission permission = (NodePermission)permissions.nextElement();
            objectUri.getStore().grantPermission(objectUri, permission);
        }
    }
}

