/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.slide.common.Domain;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.search.CompareHint;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.SlideUri;
import org.apache.slide.search.basic.ComparableResource;
import org.apache.slide.structure.ObjectNode;

public class ComparableResourceImpl
implements ComparableResource {
    private ObjectNode objectNode;
    protected NodeRevisionDescriptor revisionDescriptor;
    private Content contentHelper;
    private NodeRevisionDescriptors revisionDescriptors;
    private SlideToken slideToken;
    private SearchToken searchToken;
    protected PropertyProvider propertyProvider = null;
    protected QueryScope scope = null;
    private static final Set containsForbiddenOn = new HashSet();
    private static final int EQ = 1;
    private static final int GT = 2;
    private static final int LT = 3;
    private static final int GTE = 4;
    private static final int LTE = 5;

    static {
        containsForbiddenOn.add("image/gif");
        containsForbiddenOn.add("image/jpeg");
        containsForbiddenOn.add("image/pjpeg");
        containsForbiddenOn.add("image/jpg");
        containsForbiddenOn.add("audio/mpg");
        containsForbiddenOn.add("audio/mpeg");
    }

    protected ComparableResourceImpl() {
    }

    public ComparableResourceImpl(ObjectNode objectNode, SlideToken slideToken, Content contentHelper, QueryScope scope, PropertyProvider propertyProvider) throws SlideException {
        this.objectNode = objectNode;
        this.contentHelper = contentHelper;
        this.slideToken = slideToken;
        this.propertyProvider = propertyProvider;
        this.scope = scope;
        try {
            this.revisionDescriptors = contentHelper.retrieve(slideToken, objectNode.getUri());
            try {
                this.revisionDescriptor = contentHelper.retrieve(slideToken, this.revisionDescriptors);
            }
            catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
                this.revisionDescriptor = new NodeRevisionDescriptor(0L);
                String resourceName = objectNode.getUri();
                int lastSlash = resourceName.lastIndexOf(47);
                if (lastSlash != -1) {
                    resourceName = resourceName.substring(lastSlash + 1);
                }
                this.revisionDescriptor.setName(resourceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SlideException(e.getMessage());
        }
    }

    public ComparableResourceImpl(ObjectNode objectNode, SearchToken searchToken, QueryScope scope, PropertyProvider propertyProvider) throws SlideException {
        this(objectNode, searchToken.getSlideToken(), searchToken.getContentHelper(), scope, propertyProvider);
        this.searchToken = searchToken;
    }

    private int compare(String propName, String propNamespace, String literal, int op) {
        int result = 0;
        Object thisValue = this.getThisValue(propName, propNamespace);
        if (thisValue == null) {
            return -1;
        }
        Object otherValue = null;
        try {
            otherValue = this.getOtherValue(thisValue, literal);
            switch (op) {
                case 1: {
                    if (this.compareTo(propName, propNamespace, literal) == 0) {
                        result = 1;
                    }
                    break;
                }
                case 2: {
                    if (this.compareTo(propName, propNamespace, literal) > 0) {
                        result = 1;
                    }
                    break;
                }
                case 3: {
                    if (this.compareTo(propName, propNamespace, literal) < 0) {
                        result = 1;
                    }
                    break;
                }
                case 4: {
                    if (this.compareTo(propName, propNamespace, literal) >= 0) {
                        result = 1;
                    }
                    break;
                }
                case 5: {
                    if (this.compareTo(propName, propNamespace, literal) <= 0) {
                        result = 1;
                    }
                    break;
                }
                default: {
                    return result;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        catch (UnknownException unknownException) {
            result = -1;
        }
        return result;
    }

    private int compareTo(String propName, String propNamespace, String literal) throws NumberFormatException, UnknownException {
        int result = 0;
        Object thisValue = this.getThisValue(propName, propNamespace);
        if (thisValue == null) {
            throw new UnknownException();
        }
        Object otherValue = null;
        otherValue = this.getOtherValue(thisValue, literal);
        result = ((Comparable)thisValue).compareTo((Comparable)otherValue);
        return result;
    }

    public int compareTo(ComparableResource otherResource, CompareHint hint) {
        int result = 0;
        Comparable otherValue = (Comparable)otherResource.getThisValue(hint.getProperty(), hint.getPropNamespace());
        Comparable thisValue = (Comparable)this.getThisValue(hint.getProperty(), hint.getPropNamespace());
        if (this.getInternalHref().equals(otherResource.getInternalHref())) {
            result = 0;
        } else if (thisValue != null && otherValue != null) {
            result = thisValue.compareTo(otherValue);
            if (result == 0) {
                result = 1;
            }
        } else if (thisValue == null) {
            result = -1;
        } else if (otherValue == null) {
            result = 1;
        }
        if (!hint.isAscending()) {
            result *= -1;
        }
        return result;
    }

    public int contains(String literal) {
        int result;
        block3: {
            String contentType;
            result = -1;
            NodeProperty property = this.getProperty("getcontenttype");
            if (property == null || containsForbiddenOn.contains(contentType = (String)property.getValue())) break block3;
            try {
                NodeRevisionContent revisionContent = this.contentHelper.retrieve(this.slideToken, this.revisionDescriptors, this.revisionDescriptor);
                String content = new String(revisionContent.getContentBytes());
                if (content.indexOf(literal) > -1) {
                    result = 1;
                    break block3;
                }
                result = 0;
            }
            catch (SlideException slideException) {}
        }
        return result;
    }

    public int equals(String propName, String propNamespace, String literal) {
        return this.compare(propName, propNamespace, literal, 1);
    }

    public Iterator getAllProperties() throws SlideException {
        HashSet propertySet = new HashSet();
        Enumeration enumeration = this.revisionDescriptor.enumerateProperties();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                propertySet.add(enumeration.nextElement());
            }
        }
        if (this.propertyProvider != null) {
            Iterator iterator = this.propertyProvider.getSupportedProperties(this.getUri());
            while (iterator.hasNext()) {
                propertySet.add(iterator.next());
            }
        }
        return propertySet.iterator();
    }

    public Iterator getAllPropertiesNames() throws SlideException {
        HashSet<PropertyName> propertyNamesSet = new HashSet<PropertyName>();
        Enumeration enumeration = this.revisionDescriptor.enumerateProperties();
        NodeProperty property = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                property = (NodeProperty)enumeration.nextElement();
                propertyNamesSet.add(new PropertyName(property.getName(), property.getNamespace()));
            }
        }
        Iterator iterator = this.propertyProvider.getSupportedPropertiesNames(this.getUri());
        while (iterator.hasNext()) {
            propertyNamesSet.add((PropertyName)iterator.next());
        }
        return propertyNamesSet.iterator();
    }

    public String getExternalHref() {
        SlideUri slideContext = this.searchToken.getSlideContext();
        return slideContext.getContextPath(this.objectNode.getUri());
    }

    public String getInternalHref() {
        return this.objectNode.getUri();
    }

    private Object getOtherValue(Object thisValue, String literal) throws NumberFormatException {
        Object otherValue = null;
        otherValue = thisValue instanceof Boolean ? new Boolean(literal) : (thisValue instanceof Date ? new Date() : (thisValue instanceof Float ? new Float(literal) : (thisValue instanceof Integer ? new Integer(literal) : (thisValue instanceof Long ? new Long(literal) : literal))));
        return otherValue;
    }

    protected NodeProperty getProperty(String propName) {
        NodeProperty property = null;
        try {
            property = this.getProperty(propName, "DAV:");
        }
        catch (SlideException e) {
            Domain.error("ComparableResourceImpl.getProperty()", e);
        }
        return property;
    }

    public NodeProperty getProperty(String name, String namespace) throws SlideException {
        NodeProperty property = null;
        property = this.propertyProvider != null && this.propertyProvider.isSupportedProperty(this.getUri(), name, namespace) ? this.propertyProvider.getProperty(this.getUri(), name, namespace) : this.revisionDescriptor.getProperty(name, namespace);
        return property;
    }

    public NodeProperty getProperty(PropertyName propertyName) throws SlideException {
        return this.getProperty(propertyName.getName(), propertyName.getNamespace());
    }

    public Object getThisValue(String propName, String propNamespace) {
        Object result = null;
        NodeProperty property = null;
        try {
            property = this.getProperty(propName, propNamespace);
        }
        catch (SlideException e) {
            Domain.error("ComparableResourceImpl.getThisValue()", e);
        }
        result = property == null ? null : property.getValue();
        return result;
    }

    public String getUri() {
        return this.getInternalHref();
    }

    public int greaterThan(String propName, String propNamespace, String literal) {
        return this.compare(propName, propNamespace, literal, 2);
    }

    public int greaterThanEquals(String propName, String propNamespace, String literal) {
        return this.compare(propName, propNamespace, literal, 4);
    }

    public boolean isCollection(NodeRevisionDescriptor revisionDescriptor) {
        boolean result = false;
        if (revisionDescriptor == null) {
            return true;
        }
        NodeProperty property = revisionDescriptor.getProperty("resourcetype");
        if (property != null && property.getValue().equals("<collection/>")) {
            result = true;
        }
        return result;
    }

    public boolean isDefined(String propName, String propNamespace) {
        return this.getThisValue(propName, propNamespace) != null;
    }

    public int lowerThan(String propName, String propNamespace, String literal) {
        return this.compare(propName, propNamespace, literal, 3);
    }

    public int lowerThanEquals(String propName, String propNamespace, String literal) {
        return this.compare(propName, propNamespace, literal, 5);
    }

    public int propContains(String propName, String propNamespace, String literal) {
        Object o = this.getThisValue(propName, propNamespace);
        if (!(o instanceof String)) {
            return -1;
        }
        String thisValue = (String)o;
        if (thisValue.indexOf(literal) == -1) {
            return 0;
        }
        return 1;
    }

    private class UnknownException
    extends Exception {
        UnknownException() {
        }
    }
}

