/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search;

import org.apache.slide.common.Namespace;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.search.SlideUri;
import org.apache.slide.structure.Structure;

public class SearchToken {
    private SlideToken slideToken;
    private Content contentHelper;
    private Structure structureHelper;
    private SlideUri slideContext;
    private int maxDepth = Integer.MAX_VALUE;
    private Namespace namespace;

    private SearchToken(SlideToken token, Content content, Structure structure, int maxDepth, String requestUri, Namespace namespace) {
        this.slideToken = token;
        this.contentHelper = content;
        this.structureHelper = structure;
        this.maxDepth = maxDepth;
        this.slideContext = new SlideUri(requestUri);
        this.namespace = namespace;
    }

    public static SearchToken createSearchToken(SlideToken token, Content content, Structure structure, int maxDepth, String requestUri, Namespace namespace) {
        return new SearchToken(token, content, structure, maxDepth, requestUri, namespace);
    }

    public static SearchToken createSearchTokenForTestOnly(int maxDepth, String requestUri) {
        return new SearchToken(null, null, null, maxDepth, requestUri, null);
    }

    public Content getContentHelper() {
        return this.contentHelper;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public SlideUri getSlideContext() {
        return this.slideContext;
    }

    public SlideToken getSlideToken() {
        return this.slideToken;
    }

    public Structure getStructureHelper() {
        return this.structureHelper;
    }
}

