/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.content;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.util.Messages;

public final class NodeRevisionContent
implements Serializable {
    private static final int CHUNK = 4096;
    private char[] content = null;
    private byte[] contentBytes = null;
    private transient Reader reader = null;
    private transient InputStream inputStream = null;
    static /* synthetic */ Class class$org$apache$slide$content$NodeRevisionContent;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public char[] getContent() {
        char[] result = null;
        if (this.content != null) {
            result = this.content;
            this.inputStream = null;
            this.reader = null;
        } else if (this.reader != null) {
            try {
                this.content = this.readFromReader(this.reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result = this.content;
            this.inputStream = null;
            this.reader = null;
        } else if (this.contentBytes != null) {
            result = this.content = new String(this.contentBytes).toCharArray();
            this.inputStream = null;
            this.reader = null;
        } else if (this.inputStream != null) {
            try {
                this.contentBytes = NodeRevisionContent.readFromStream(this.inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result = this.content = new String(this.contentBytes).toCharArray();
            this.inputStream = null;
            this.reader = null;
        }
        return result;
    }

    public byte[] getContentBytes() {
        byte[] result = null;
        if (this.contentBytes != null) {
            result = this.contentBytes;
            this.inputStream = null;
            this.reader = null;
        } else if (this.inputStream != null) {
            try {
                this.contentBytes = NodeRevisionContent.readFromStream(this.inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result = this.contentBytes;
            this.inputStream = null;
            this.reader = null;
        } else if (this.content != null) {
            result = this.contentBytes = new String(this.content).getBytes();
            this.inputStream = null;
            this.reader = null;
        } else if (this.reader != null) {
            try {
                this.content = this.readFromReader(this.reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result = this.contentBytes = new String(this.content).getBytes();
            this.inputStream = null;
            this.reader = null;
        }
        return result;
    }

    public Reader readContent() throws IOException {
        Reader result = null;
        if (this.reader != null) {
            result = this.reader;
            this.inputStream = null;
        } else if (this.content != null) {
            result = new CharArrayReader(this.content);
            this.inputStream = null;
            this.reader = null;
        } else if (this.inputStream != null) {
            result = new InputStreamReader(this.inputStream);
            this.reader = null;
        } else if (this.contentBytes != null) {
            result = new CharArrayReader(new String(this.contentBytes).toCharArray());
            this.inputStream = null;
            this.reader = null;
        }
        return result;
    }

    private char[] readFromReader(Reader reader) throws IOException {
        int allLen = 0;
        char[] chunk = new char[4096];
        int chunkLen = reader.read(chunk);
        ArrayList<Object> chunks = new ArrayList<Object>();
        while (chunkLen != -1) {
            chunks.add(new Integer(chunkLen));
            chunks.add(chunk);
            allLen += chunkLen;
            chunk = new char[4096];
            chunkLen = reader.read(chunk);
        }
        char[] all = new char[allLen];
        int ofs = 0;
        int max = chunks.size();
        int i = 0;
        while (i < max) {
            chunkLen = (Integer)chunks.get(i);
            chunk = (char[])chunks.get(i + 1);
            System.arraycopy(chunk, 0, all, ofs, chunkLen);
            ofs += chunkLen;
            i += 2;
        }
        return all;
    }

    public static byte[] readFromStream(InputStream inputStream) throws IOException {
        int allLen = 0;
        byte[] chunk = new byte[4096];
        int chunkLen = inputStream.read(chunk);
        ArrayList<Object> chunks = new ArrayList<Object>();
        while (chunkLen != -1) {
            chunks.add(new Integer(chunkLen));
            chunks.add(chunk);
            allLen += chunkLen;
            chunk = new byte[4096];
            chunkLen = inputStream.read(chunk);
        }
        byte[] all = new byte[allLen];
        int ofs = 0;
        int max = chunks.size();
        int i = 0;
        while (i < max) {
            chunkLen = (Integer)chunks.get(i);
            chunk = (byte[])chunks.get(i + 1);
            System.arraycopy(chunk, 0, all, ofs, chunkLen);
            ofs += chunkLen;
            i += 2;
        }
        return all;
    }

    public void setContent(InputStream inputStream) {
        this.inputStream = inputStream;
        this.reader = null;
        this.content = null;
        this.contentBytes = null;
    }

    public void setContent(Reader reader) {
        this.reader = reader;
        this.inputStream = null;
        this.content = null;
        this.contentBytes = null;
    }

    public void setContent(byte[] contentBytes) {
        this.contentBytes = contentBytes;
        this.reader = null;
        this.inputStream = null;
        this.content = null;
    }

    public void setContent(char[] content) {
        this.content = content;
        this.reader = null;
        this.inputStream = null;
        this.contentBytes = null;
    }

    public InputStream streamContent() throws IOException {
        InputStream result = null;
        if (this.inputStream != null) {
            result = this.inputStream;
            this.content = null;
            this.reader = null;
        } else if (this.contentBytes != null) {
            result = new ByteArrayInputStream(this.contentBytes);
            this.reader = null;
            this.inputStream = null;
        } else if (this.content != null) {
            result = new ByteArrayInputStream(new String(this.content).getBytes());
            this.reader = null;
            this.inputStream = null;
        }
        return result;
    }

    public void validate() {
        if (this.content == null && this.contentBytes == null && this.reader == null && this.inputStream == null) {
            throw new ObjectValidationFailedException(Messages.message(String.valueOf((class$org$apache$slide$content$NodeRevisionContent != null ? class$org$apache$slide$content$NodeRevisionContent : (class$org$apache$slide$content$NodeRevisionContent = NodeRevisionContent.class$("org.apache.slide.content.NodeRevisionContent"))).getName()) + ".noContent"));
        }
    }
}

