/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.Scope;
import org.apache.slide.common.Uri;

public final class UriTokenizer
extends StringTokenizer {
    Vector uris = new Vector();
    int pos;
    Namespace namespace;

    public UriTokenizer(Namespace namespace, String uri) {
        super(uri, "/");
        this.namespace = namespace;
        String courScope = new String();
        this.uris.addElement("/");
        while (super.hasMoreTokens()) {
            courScope = String.valueOf(courScope) + "/" + super.nextToken();
            this.uris.addElement(courScope);
        }
        this.pos = 0;
    }

    public UriTokenizer(Namespace namespace, Scope scope) {
        this(namespace, scope.toString());
    }

    public Uri getParentUri() {
        if (this.uris.size() < 1) {
            return null;
        }
        return this.namespace.getUri((String)this.uris.elementAt(this.uris.size() - 1));
    }

    public boolean hasMoreElements() {
        return this.uris.size() > this.pos;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreElements();
    }

    public Object nextElement() throws NoSuchElementException {
        Object obj = null;
        try {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            obj = this.uris.elementAt(this.pos);
            ++this.pos;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public String nextToken() throws NoSuchElementException {
        return (String)this.nextElement();
    }

    public String nextToken(String delim) throws NoSuchElementException {
        return this.nextToken();
    }

    public Uri nextUri() throws NoSuchElementException {
        return this.namespace.getUri(this.nextToken());
    }
}

