/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessTokenImpl;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.Scope;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceRegistrationFailedException;
import org.apache.slide.common.ServicesInitializationFailedException;
import org.apache.slide.common.ServicesShutDownFailedException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.common.UnknownServiceDeclarationException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.ContentInterceptor;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.Store;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.transaction.SlideTransactionManager;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.logger.Logger;

public final class Namespace {
    public static final String REFERENCE = "reference";
    public static final String NODE_STORE = "nodestore";
    public static final String SECURITY_STORE = "securitystore";
    public static final String LOCK_STORE = "lockstore";
    public static final String REVISION_DESCRIPTORS_STORE = "revisiondescriptorsstore";
    public static final String REVISION_DESCRIPTOR_STORE = "revisiondescriptorstore";
    public static final String CONTENT_STORE = "contentstore";
    private static final String LOG_CHANNEL = (class$org$apache$slide$common$Namespace != null ? class$org$apache$slide$common$Namespace : (class$org$apache$slide$common$Namespace = Namespace.class$("org.apache.slide.common.Namespace"))).getName();
    protected static final String I_CREATESTORELISTENERCLASS = "createStoreListenerClass";
    protected static final String I_CREATESTORELISTENERCLASS_DEFAULT = "org.apache.slide.webdav.util.UriHandler";
    protected static Class createStoreListenerClass;
    private String name;
    private String searchClassName;
    private transient Vector connectedServices;
    private transient Hashtable stores;
    private NamespaceConfig config;
    private Hashtable uriCache;
    private String defaultStoreClassname = "org.apache.slide.store.StandardStore";
    private TransactionManager transactionManager = new SlideTransactionManager();
    private Logger logger;
    private Logger applicationLogger;
    static /* synthetic */ Class class$org$apache$slide$common$Namespace;
    static /* synthetic */ Class class$java$lang$String;

    static {
        try {
            String createStoreListenerClassName = Domain.getParameter(I_CREATESTORELISTENERCLASS, I_CREATESTORELISTENERCLASS_DEFAULT);
            createStoreListenerClass = Class.forName(createStoreListenerClassName);
        }
        catch (Exception x) {
            Domain.warn("Loading of create_store_listener class failed: " + x.getMessage());
        }
    }

    Namespace() {
        this.stores = new Hashtable();
        this.connectedServices = new Vector();
        this.name = new String();
        this.uriCache = new Hashtable();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clearNamespace() {
        this.stores.clear();
    }

    void clearUriCache() {
        this.uriCache.clear();
    }

    public void connectService(Service service, CredentialsToken token) throws ServiceConnectionFailedException, ServiceAccessException {
        boolean newConnection = service.connectIfNeeded(token);
        if (newConnection) {
            this.connectedServices.addElement(service);
        }
    }

    public void disconnectServices() throws ServicesShutDownFailedException {
        ServicesShutDownFailedException nestedException = new ServicesShutDownFailedException();
        int i = 0;
        while (i < this.connectedServices.size()) {
            try {
                Service service = (Service)this.connectedServices.elementAt(i);
                if (service.isConnected()) {
                    this.getLogger().log("Shutting down service " + service, LOG_CHANNEL, 6);
                    service.disconnect();
                }
            }
            catch (ServiceDisconnectionFailedException e) {
                nestedException.addException(e);
            }
            catch (ServiceAccessException e) {
                nestedException.addException(e);
            }
            ++i;
        }
        this.connectedServices.removeAllElements();
        if (!nestedException.isEmpty()) {
            throw nestedException;
        }
    }

    public Enumeration enumerateScopes() {
        return this.stores.keys();
    }

    public Logger getApplicationLogger() {
        if (this.applicationLogger != null) {
            return this.applicationLogger;
        }
        if (this.logger != null) {
            return this.logger;
        }
        return Domain.getLogger();
    }

    public NamespaceConfig getConfig() {
        return this.config;
    }

    public ContentInterceptor[] getContentInterceptors() {
        return this.config.getContentInterceptors();
    }

    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return Domain.getLogger();
    }

    public String getName() {
        return this.name;
    }

    public String getSearchClassName() {
        return this.searchClassName;
    }

    public Store getStore(Scope scope) {
        Store store = null;
        if (this.stores.containsKey(scope)) {
            store = (Store)this.stores.get(scope);
        }
        return store;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Uri getUri(String uri) {
        return this.getUri(null, uri);
    }

    public Uri getUri(SlideToken token, String uri) {
        return this.getUri(token, uri, token == null ? false : token.isForceStoreEnlistment());
    }

    public Uri getUri(SlideToken token, String uri, boolean forcedEnlistment) {
        Uri result = null;
        Object temp = null;
        temp = this.uriCache.get(uri);
        if (temp == null) {
            result = new Uri(token, this, uri);
            this.uriCache.put(uri, result);
            if (this.uriCache.size() > 10000) {
                this.clearUriCache();
            }
        } else {
            result = temp;
            result = result.cloneObject();
            result.setToken(token);
            result.reconnectServices();
        }
        if (token != null && token.isForceStoreEnlistment() != forcedEnlistment) {
            result.setToken(new SlideTokenWrapper(token, forcedEnlistment));
        }
        return result;
    }

    public void initializeServices() throws ServicesInitializationFailedException {
        ServicesInitializationFailedException nestedException = new ServicesInitializationFailedException();
        Enumeration serviceList = this.stores.elements();
        while (serviceList.hasMoreElements()) {
            Service service = (Service)serviceList.nextElement();
            try {
                this.getLogger().log("Initializing Store " + service, LOG_CHANNEL, 6);
                service.setNamespace(this);
                service.initialize(new NamespaceAccessTokenImpl(this));
            }
            catch (ServiceInitializationFailedException e) {
                nestedException.addException(e);
            }
        }
        if (!nestedException.isEmpty()) {
            throw nestedException;
        }
    }

    void loadBaseData(Configuration namespaceBaseDataDefinition) throws SlideException, ConfigurationException {
        block9: {
            this.getLogger().log("Loading namespace " + this.getName() + " base data", LOG_CHANNEL, 6);
            try {
                this.getTransactionManager().begin();
                Uri rootUri = this.getUri("/");
                SubjectNode rootNode = new SubjectNode("/");
                NodePermission allAccess = new NodePermission("/", "/", "/");
                try {
                    rootUri.getStore().createObject(rootUri, rootNode);
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                    this.getTransactionManager().rollback();
                    this.getTransactionManager().begin();
                }
                rootUri.getStore().grantPermission(rootUri, allAccess);
                Uri tempActionUri = this.getUri("/tempaction");
                ActionNode tempAction = new ActionNode("/tempaction");
                tempActionUri.getStore().createObject(tempActionUri, tempAction);
                this.getTransactionManager().commit();
                this.getLogger().log("Init namespace " + this.getName() + " configuration", LOG_CHANNEL, 6);
                this.config.initializeAsDummyConfig(this);
                NamespaceAccessTokenImpl token = new NamespaceAccessTokenImpl(this);
                token.begin();
                this.getLogger().log("Import data into namespace " + this.getName(), LOG_CHANNEL, 6);
                token.importData((SlideToken)new SlideTokenImpl(new CredentialsToken(new String("/"))), namespaceBaseDataDefinition);
                token.commit();
                this.getTransactionManager().begin();
                this.getLogger().log("Finish init namespace " + this.getName() + " configuration", LOG_CHANNEL, 6);
                tempActionUri.getStore().removeObject(tempActionUri, tempAction);
                rootNode = (SubjectNode)rootUri.getStore().retrieveObject(rootUri);
                rootUri.getStore().revokePermission(rootUri, allAccess);
                rootUri.getStore().storeObject(rootUri, rootNode);
                this.getTransactionManager().commit();
            }
            catch (SlideException e) {
                e.printStackTrace();
                this.getLogger().log("Namespace base configuration was already done before", LOG_CHANNEL, 6);
                try {
                    if (this.getTransactionManager().getStatus() != 0) break block9;
                    this.getTransactionManager().rollback();
                }
                catch (SystemException ex) {
                    this.getLogger().log("Could not rollback namespace base configuration: " + ex.toString(), LOG_CHANNEL, 4);
                }
            }
            catch (Exception e) {
                this.getLogger().log("Unable to read Namespace base configuration file : ", LOG_CHANNEL, 2);
                this.getLogger().log(e, LOG_CHANNEL, 2);
                try {
                    if (this.getTransactionManager().getStatus() != 0) break block9;
                    this.getTransactionManager().rollback();
                }
                catch (SystemException ex) {
                    this.getLogger().log("Could not rollback namespace base configuration after load error: " + ex.toString(), LOG_CHANNEL, 4);
                }
            }
        }
    }

    private Service loadChildStore(Configuration childStoreDefinition, Hashtable fatherParameters) throws ConfigurationException, SlideException {
        String childStoreClassname = childStoreDefinition.getAttribute("classname");
        Service childStore = null;
        try {
            Class<?> childStoreClass = Class.forName(childStoreClassname);
            childStore = (Service)childStoreClass.newInstance();
        }
        catch (Exception e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            return null;
        }
        Hashtable childStoreParameters = new Hashtable();
        Enumeration fatherParametersKeys = fatherParameters.keys();
        while (fatherParametersKeys.hasMoreElements()) {
            Object key = fatherParametersKeys.nextElement();
            Object value = fatherParameters.get(key);
            childStoreParameters.put(key, value);
        }
        Enumeration childStoreParametersDefinitions = childStoreDefinition.getConfigurations("parameter");
        while (childStoreParametersDefinitions.hasMoreElements()) {
            Configuration parameterDefinition = (Configuration)childStoreParametersDefinitions.nextElement();
            String parameterName = parameterDefinition.getAttribute("name");
            String parameterValue = parameterDefinition.getValue();
            childStoreParameters.put(parameterName, parameterValue);
        }
        childStore.setParameters(childStoreParameters);
        return childStore;
    }

    void loadConfiguration(Configuration namespaceConfigurationDefinition) throws SlideException {
        this.getLogger().log("Loading namespace " + this.getName() + " configuration", LOG_CHANNEL, 6);
        this.config = new NamespaceConfig();
        this.config.initializeNamespaceConfig(this, namespaceConfigurationDefinition);
    }

    void loadDefinition(Configuration definition) throws SlideException, ConfigurationException {
        this.getLogger().log("Loading namespace definition", LOG_CHANNEL, 6);
        Hashtable storesClass = new Hashtable();
        Hashtable storesParameters = new Hashtable();
        Hashtable childStores = new Hashtable();
        Enumeration storeDefinitions = definition.getConfigurations("store");
        while (storeDefinitions.hasMoreElements()) {
            this.loadStoreDefinition((Configuration)storeDefinitions.nextElement(), storesClass, storesParameters, childStores);
        }
        Enumeration scopeDefinitions = definition.getConfigurations("scope");
        while (scopeDefinitions.hasMoreElements()) {
            this.loadScopeDefinition((Configuration)scopeDefinitions.nextElement(), storesClass, storesParameters, childStores);
        }
        this.initializeServices();
    }

    void loadParameters(Configuration namespaceConfigurationDefinition) throws SlideException {
        this.getLogger().log("Loading namespace " + this.getName() + " parameters", LOG_CHANNEL, 6);
        this.config = new NamespaceConfig();
        this.config.initializeNamespaceParameters(this, namespaceConfigurationDefinition);
    }

    private void loadScopeDefinition(Configuration scopeDefinition, Hashtable storesClass, Hashtable storesParameters, Hashtable childStores) throws ConfigurationException, UnknownServiceDeclarationException, ServiceParameterErrorException, ServiceParameterMissingException, ServiceRegistrationFailedException {
        String match = scopeDefinition.getAttribute("match");
        String storeName = scopeDefinition.getAttribute("store");
        if (storeName != null) {
            if (!storesClass.containsKey(storeName) || !storesParameters.containsKey(storeName)) {
                throw new UnknownServiceDeclarationException(storeName);
            }
            this.registerStore(storeName, (Class)storesClass.get(storeName), (Hashtable)storesParameters.get(storeName), new Scope(match), (Hashtable)childStores.get(storeName));
            this.getLogger().log("Registering Store " + storeName + " of class " + storesClass.get(storeName) + " with parameters " + storesParameters.get(storeName) + " on scope " + match, LOG_CHANNEL, 6);
        }
    }

    private void loadStoreDefinition(Configuration storeDefinition, Hashtable storesClass, Hashtable storesParameters, Hashtable childStores) throws ConfigurationException, SlideException {
        Configuration referenceDefinition;
        String storeName = storeDefinition.getAttribute("name");
        String storeClassname = this.defaultStoreClassname;
        try {
            storeClassname = storeDefinition.getAttribute("classname");
        }
        catch (ConfigurationException configurationException) {}
        Enumeration storeParametersDefinitions = storeDefinition.getConfigurations("parameter");
        Class<?> storeClass = null;
        try {
            storeClass = Class.forName(storeClassname);
        }
        catch (Exception e) {
            this.getLogger().log(e, LOG_CHANNEL, 2);
            throw new SlideException(e.getMessage());
        }
        storesClass.put(storeName, storeClass);
        Hashtable<String, String> storeParameters = new Hashtable<String, String>();
        while (storeParametersDefinitions.hasMoreElements()) {
            Configuration parameterDefinition = (Configuration)storeParametersDefinitions.nextElement();
            String parameterName = parameterDefinition.getAttribute("name");
            String parameterValue = parameterDefinition.getValue();
            storeParameters.put(parameterName, parameterValue);
        }
        storesParameters.put(storeName, storeParameters);
        Hashtable<String, Object> currentStoreChildStores = new Hashtable<String, Object>();
        try {
            Configuration nodeStoreDefinition = storeDefinition.getConfiguration(NODE_STORE);
            try {
                referenceDefinition = storeDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(NODE_STORE, referenceDefinition.getAttribute("store"));
                this.getLogger().log("Node store references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException configurationException) {
                this.getLogger().log("Node store: " + nodeStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                NodeStore nodeStore = (NodeStore)this.loadChildStore(nodeStoreDefinition, storeParameters);
                if (nodeStore != null) {
                    currentStoreChildStores.put(NODE_STORE, nodeStore);
                }
            }
        }
        catch (Exception exception) {}
        try {
            Configuration securityStoreDefinition = storeDefinition.getConfiguration(SECURITY_STORE);
            try {
                referenceDefinition = securityStoreDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(SECURITY_STORE, referenceDefinition.getAttribute("store"));
                this.getLogger().log("Security store references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException configurationException) {
                this.getLogger().log("Security store: " + securityStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                SecurityStore securityStore = (SecurityStore)this.loadChildStore(securityStoreDefinition, storeParameters);
                if (securityStore != null) {
                    currentStoreChildStores.put(SECURITY_STORE, securityStore);
                }
            }
        }
        catch (Exception exception) {}
        try {
            Configuration lockStoreDefinition = storeDefinition.getConfiguration(LOCK_STORE);
            try {
                referenceDefinition = lockStoreDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(LOCK_STORE, referenceDefinition.getAttribute("store"));
                this.getLogger().log("Lock store store references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException configurationException) {
                this.getLogger().log("Lock store store: " + lockStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                LockStore lockStore = (LockStore)this.loadChildStore(lockStoreDefinition, storeParameters);
                if (lockStore != null) {
                    currentStoreChildStores.put(LOCK_STORE, lockStore);
                }
            }
        }
        catch (Exception exception) {}
        try {
            Configuration revisionDescriptorsStoreDefinition = storeDefinition.getConfiguration(REVISION_DESCRIPTORS_STORE);
            try {
                referenceDefinition = revisionDescriptorsStoreDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(REVISION_DESCRIPTORS_STORE, referenceDefinition.getAttribute("store"));
                this.getLogger().log("Revision descriptors store references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException configurationException) {
                this.getLogger().log("Revision descriptors store: " + revisionDescriptorsStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                RevisionDescriptorsStore revisionDescriptorsStore = (RevisionDescriptorsStore)this.loadChildStore(revisionDescriptorsStoreDefinition, storeParameters);
                if (revisionDescriptorsStore != null) {
                    currentStoreChildStores.put(REVISION_DESCRIPTORS_STORE, revisionDescriptorsStore);
                }
            }
        }
        catch (Exception exception) {}
        try {
            Configuration revisionDescriptorStoreDefinition = storeDefinition.getConfiguration(REVISION_DESCRIPTOR_STORE);
            try {
                referenceDefinition = revisionDescriptorStoreDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(REVISION_DESCRIPTOR_STORE, referenceDefinition.getAttribute("store"));
                this.getLogger().log("Revision descriptor store references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException configurationException) {
                this.getLogger().log("Revision descriptor store: " + revisionDescriptorStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                RevisionDescriptorStore revisionDescriptorStore = (RevisionDescriptorStore)this.loadChildStore(revisionDescriptorStoreDefinition, storeParameters);
                if (revisionDescriptorStore != null) {
                    currentStoreChildStores.put(REVISION_DESCRIPTOR_STORE, revisionDescriptorStore);
                }
            }
        }
        catch (Exception exception) {}
        try {
            Configuration contentStoreDefinition = storeDefinition.getConfiguration(CONTENT_STORE);
            try {
                referenceDefinition = contentStoreDefinition.getConfiguration(REFERENCE);
                currentStoreChildStores.put(CONTENT_STORE, referenceDefinition.getAttribute("store"));
                this.getLogger().log("Content store references " + referenceDefinition.getAttribute("store"), LOG_CHANNEL, 6);
            }
            catch (ConfigurationException configurationException) {
                this.getLogger().log("Content store: " + contentStoreDefinition.getAttribute("classname"), LOG_CHANNEL, 6);
                ContentStore contentStore = (ContentStore)this.loadChildStore(contentStoreDefinition, storeParameters);
                if (contentStore != null) {
                    currentStoreChildStores.put(CONTENT_STORE, contentStore);
                }
            }
        }
        catch (Exception exception) {}
        childStores.put(storeName, currentStoreChildStores);
    }

    private void notifyStoreCreated(String namespaceName, String scope, String storeName) {
        block2: {
            if (createStoreListenerClass == null) break block2;
            try {
                Method nsc = createStoreListenerClass.getMethod("notifyStoreCreated", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Namespace.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Namespace.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Namespace.class$("java.lang.String")));
                nsc.invoke(null, namespaceName, scope, storeName);
            }
            catch (Exception x) {
                Domain.warn("Notification of store creation (namespace=" + namespaceName + ", scope=" + scope + ", store=" + storeName + ") failed: " + x.getMessage());
            }
        }
    }

    public void registerStore(String storeName, Class storeClass, Hashtable parameters, Scope scope, Hashtable childStores) throws ServiceRegistrationFailedException, ServiceParameterErrorException, ServiceParameterMissingException {
        if (!this.stores.containsKey(scope)) {
            try {
                Store store = (Store)storeClass.newInstance();
                store.setName(storeName);
                store.setParameters(parameters);
                this.stores.put(scope, store);
                Object nodeStore = childStores.get(NODE_STORE);
                if (nodeStore instanceof String) {
                    store.setNodeStore((NodeStore)childStores.get(nodeStore));
                } else {
                    store.setNodeStore((NodeStore)nodeStore);
                }
                Object securityStore = childStores.get(SECURITY_STORE);
                if (securityStore instanceof String) {
                    store.setSecurityStore((SecurityStore)childStores.get(securityStore));
                } else {
                    store.setSecurityStore((SecurityStore)securityStore);
                }
                Object lockStore = childStores.get(LOCK_STORE);
                if (lockStore instanceof String) {
                    store.setLockStore((LockStore)childStores.get(lockStore));
                } else {
                    store.setLockStore((LockStore)lockStore);
                }
                Object revisionDescriptorsStore = childStores.get(REVISION_DESCRIPTORS_STORE);
                if (revisionDescriptorsStore instanceof String) {
                    store.setRevisionDescriptorsStore((RevisionDescriptorsStore)childStores.get(revisionDescriptorsStore));
                } else {
                    store.setRevisionDescriptorsStore((RevisionDescriptorsStore)revisionDescriptorsStore);
                }
                Object revisionDescriptorStore = childStores.get(REVISION_DESCRIPTOR_STORE);
                if (revisionDescriptorStore instanceof String) {
                    store.setRevisionDescriptorStore((RevisionDescriptorStore)childStores.get(revisionDescriptorStore));
                } else {
                    store.setRevisionDescriptorStore((RevisionDescriptorStore)revisionDescriptorStore);
                }
                Object contentStore = childStores.get(CONTENT_STORE);
                if (contentStore instanceof String) {
                    store.setContentStore((ContentStore)childStores.get(contentStore));
                } else {
                    store.setContentStore((ContentStore)contentStore);
                }
                store.setScope(scope);
                this.notifyStoreCreated(this.name, scope.toString(), storeName);
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceRegistrationFailedException(storeClass);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceRegistrationFailedException(storeClass);
            }
            catch (NullPointerException nullPointerException) {
                throw new ServiceRegistrationFailedException(storeClass);
            }
            catch (ClassCastException e) {
                this.getLogger().log(e, LOG_CHANNEL, 2);
                throw new ServiceRegistrationFailedException(storeClass);
            }
        }
    }

    public Store retrieveStore(Scope scope, CredentialsToken token) throws ServiceConnectionFailedException, ServiceAccessException {
        Store store = this.getStore(scope);
        if (store != null) {
            this.connectService(store, token);
        }
        return store;
    }

    public void setApplicationLogger(Logger logger) {
        this.applicationLogger = this.applicationLogger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        if (this.transactionManager instanceof SlideTransactionManager) {
            ((SlideTransactionManager)this.transactionManager).setLogger(logger);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSearchClassName(String searchClassName) {
        this.searchClassName = searchClassName;
    }

    public String toString() {
        return this.getName();
    }

    public void unregisterStore(Scope scope) throws ServiceDisconnectionFailedException, ServiceAccessException {
        if (this.stores.containsKey(scope)) {
            Store store = (Store)this.stores.get(scope);
            if (store.isConnected()) {
                store.disconnect();
                this.connectedServices.removeElement(store);
            }
            this.stores.remove(scope);
            Object var2_2 = null;
        }
    }
}

