/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;

public abstract class AbstractSimpleService
extends AbstractServiceBase
implements Service {
    public static final int TX_IDLE = 0;
    public static final int TX_PREPARED = 1;
    public static final int TX_SUSPENDED = 2;
    protected Xid currentContext = null;
    protected int status = 0;
    protected int transactionTimeout = 30;
    protected boolean rollbackOnly = false;

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this.currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        if (!onePhase && this.status != 1) {
            throw new XAException(-6);
        }
        if (onePhase && this.status != 0 && this.status != 2) {
            throw new XAException(-6);
        }
        if (this.rollbackOnly) {
            this.rollback(xid);
            throw new XAException(100);
        }
        this.currentContext = null;
        this.status = 0;
        this.rollbackOnly = false;
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this.currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        if (flags == 0x2000000) {
            this.status = 2;
        }
        if (flags == 0x20000000) {
            this.rollbackOnly = true;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this.currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        this.currentContext = null;
        this.status = 0;
        this.rollbackOnly = false;
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares == null) {
            return false;
        }
        return this == xares;
    }

    public int prepare(Xid xid) throws XAException {
        if (this.currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this.currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        if (this.status != 0 && this.status != 2) {
            throw new XAException(-6);
        }
        if (this.rollbackOnly) {
            throw new XAException(100);
        }
        this.status = 1;
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        Vector<Xid> list = new Vector<Xid>();
        if (this.status == 1 && this.currentContext != null) {
            list.addElement(this.currentContext);
        }
        return list.toArray(new Xid[list.size()]);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.currentContext == null) {
            throw new XAException(-4);
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this.currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-6);
        }
        this.status = 0;
        this.currentContext = null;
        this.rollbackOnly = false;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.transactionTimeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        if (this.currentContext != null && this.currentContext.getGlobalTransactionId() != xid.getGlobalTransactionId()) {
            throw new XAException(-9);
        }
        switch (flags) {
            case 0: {
                if (this.currentContext != null) {
                    throw new XAException(-5);
                }
                this.currentContext = xid;
                break;
            }
            case 0x200000: {
                if (this.currentContext == null) {
                    throw new XAException(-4);
                }
                if (this.currentContext.getGlobalTransactionId() == xid.getGlobalTransactionId()) break;
                throw new XAException(-5);
            }
            case 0x8000000: {
                if (this.currentContext == null) {
                    throw new XAException(-4);
                }
                if (this.status != 2) {
                    throw new XAException(-5);
                }
                this.status = 0;
                break;
            }
        }
    }
}

