/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.transport;

import com.hp.soap.client.ClientMessage;
import com.hp.soap.client.SoapBody;
import com.hp.soap.client.SoapClient;
import com.hp.soap.client.SoapException;
import com.hp.soap.xml.XMLUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.uddi4j.UDDIElement;
import org.uddi4j.transport.Transport;
import org.uddi4j.transport.TransportException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HPSOAPTransport
implements Transport {
    boolean debug = true;
    boolean useProxy = false;
    URL httpProxy = null;
    URL httpsProxy = null;
    PrintStream print = System.out;
    public SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public HPSOAPTransport() {
        File file = null;
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("http.proxyPort");
        String string3 = System.getProperty("https.proxyHost");
        String string4 = System.getProperty("https.proxyPort");
        try {
            if (string2 != null && string != null) {
                this.httpProxy = new URL("http", string, Integer.parseInt(string2), "");
                this.useProxy = true;
            } else if (string4 != null && string3 != null) {
                this.httpsProxy = new URL("https", string3, Integer.parseInt(string4), "");
                this.useProxy = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Invalid URL for proxy");
            malformedURLException.printStackTrace();
            this.useProxy = false;
        }
        try {
            String string5 = System.getProperty("org.uddi4j.logEnabled");
            if (string5 != null && string5.equalsIgnoreCase("true")) {
                this.debug = true;
                String string6 = System.getProperty("hpsoap.logFileName");
                String string7 = System.getProperty("hpsoap.logDirectory");
                if (string6 != null) {
                    boolean bl;
                    if (string7 != null) {
                        File file2 = new File(string7);
                        if (file2.exists()) {
                            file = new File(file2, string6);
                        } else {
                            System.out.println("The Dir " + string7 + " does not exist, would use the current working directory for the log file");
                            file = new File(string6);
                        }
                    } else {
                        file = new File(string6);
                    }
                    if (!file.exists() && (bl = file.createNewFile())) {
                        System.out.println("Created " + file.getName() + " for logging");
                    }
                    this.print = new PrintStream(new FileOutputStream(file), true);
                }
                this.print.println("UDDI4J log started: " + this.LOG_DATE_FORMAT.format(new Date()));
            } else {
                this.debug = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.print = System.out;
        }
    }

    public Element send(UDDIElement uDDIElement, URL uRL) throws TransportException {
        Element element = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            element = documentBuilder.newDocument().createElement("SOAP:Body");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.print.println("FATAL error : bailing out");
            System.exit(-1);
        }
        uDDIElement.saveToXML(element);
        return this.send(element, uRL);
    }

    public Element send(Element element, URL uRL) throws TransportException {
        Element element2 = null;
        Node node = null;
        SoapClient soapClient = null;
        ClientMessage clientMessage = null;
        String string = System.getProperty("org.uddi4j.logEnabled");
        try {
            soapClient = this.useProxy ? (uRL.getProtocol().equalsIgnoreCase("HTTP") ? new SoapClient(uRL, this.httpProxy) : new SoapClient(uRL, this.httpsProxy)) : new SoapClient(uRL);
            if (string != null && string.equalsIgnoreCase("true")) {
                soapClient.setLogStream(this.print);
            } else {
                soapClient.setLogStream(null);
            }
            ClientMessage clientMessage2 = new ClientMessage();
            clientMessage2.getEnvelope().removeAttribute("SOAP:encodingStyle");
            SoapBody soapBody = new SoapBody(element);
            clientMessage2.setBody(soapBody);
            clientMessage = soapClient.sendRequest(clientMessage2);
            if (clientMessage != null) {
                if (clientMessage.getBody() != null) {
                    node = clientMessage.getBody().getElement().getFirstChild();
                } else {
                    this.print.println("INFO:The SOAP Body of the response obtained from Server is null");
                }
                element2 = (Element)node;
            } else {
                this.print.println("INFO:The SOAP Response from Server is null");
            }
        }
        catch (SoapException soapException) {
            String string2 = soapException.getMessage();
            Element element3 = null;
            try {
                element3 = XMLUtil.stringToElement((String)string2);
            }
            catch (Exception exception) {
                throw new TransportException(exception);
            }
            return element3;
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
        return element2;
    }
}

