/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Name;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceInfo
extends UDDIElement {
    public static final String UDDI_TAG = "serviceInfo";
    protected Element base = null;
    String serviceKey = null;
    String businessKey = null;
    Name name = null;

    public ServiceInfo() {
    }

    public ServiceInfo(String string, String string2) {
        this.serviceKey = string;
        this.name = new Name(string2);
    }

    public ServiceInfo(Element element) throws UDDIException {
        super(element);
        this.serviceKey = element.getAttribute("serviceKey");
        this.businessKey = element.getAttribute("businessKey");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "name");
        if (nodeList.getLength() > 0) {
            this.name = new Name((Element)nodeList.item(0));
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Name getName() {
        return this.name;
    }

    public String getNameString() {
        return this.name.getText();
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.serviceKey != null) {
            this.base.setAttribute("serviceKey", this.serviceKey);
        }
        if (this.businessKey != null) {
            this.base.setAttribute("businessKey", this.businessKey);
        }
        if (this.name != null) {
            this.name.saveToXML(this.base);
        }
        element.appendChild(this.base);
    }

    public void setBusinessKey(String string) {
        this.businessKey = string;
    }

    public void setName(String string) {
        this.name = new Name();
        this.name.setText(string);
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setServiceKey(String string) {
        this.serviceKey = string;
    }
}

