/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;
import org.hsql.StringConverter;
import org.hsql.WebServer;

class WebServerConnection
extends Thread {
    static final String ENCODING = "8859_1";
    private static final int GET = 1;
    private static final int HEAD = 2;
    private static final int POST = 3;
    private static final int BAD_REQUEST = 400;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private Socket mSocket;
    private WebServer mServer;

    public void run() {
        try {
            StringTokenizer stringTokenizer;
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream(), ENCODING));
            String string2 = null;
            int n = 400;
            int n2 = -1;
            while ((string = bufferedReader.readLine()) != null && (stringTokenizer = new StringTokenizer(string, " ")).hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("GET")) {
                    n = 1;
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                if (string3.equals("HEAD")) {
                    n = 2;
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                if (string3.equals("POST")) {
                    n = 3;
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                if (!string.toUpperCase().startsWith("CONTENT-LENGTH:")) continue;
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            switch (n) {
                case 400: {
                    this.processError(400);
                    break;
                }
                case 1: {
                    this.processGet(string2, true);
                    break;
                }
                case 2: {
                    this.processGet(string2, false);
                    break;
                }
                case 3: {
                    this.processPost(bufferedReader, string2, n2);
                    break;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processGet(String string, boolean bl) {
        try {
            String string2;
            Object object;
            if (string.endsWith("/")) {
                string = string + this.mServer.mDefaultFile;
            }
            if (string.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            string = this.mServer.mRoot + string;
            if (this.mServer.mPathSeparatorChar != '/') {
                string = string.replace('/', this.mServer.mPathSeparatorChar);
            }
            String string3 = null;
            int n = string.lastIndexOf(".");
            if (n != -1) {
                object = string.substring(n).toLowerCase();
                string3 = this.mServer.mProperties.getProperty((String)object);
            }
            if (string3 == null) {
                string3 = "text/html";
            }
            object = null;
            try {
                object = new BufferedInputStream(new FileInputStream(new File(string)));
                int n2 = ((BufferedInputStream)object).available();
                string2 = this.getHead("HTTP/1.0 200 OK", "Content-Type: " + string3 + "\n" + "Content-Length: " + n2);
            }
            catch (IOException iOException) {
                this.processError(404);
                return;
            }
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            dataOutputStream.write(string2.getBytes(ENCODING));
            if (bl) {
                int n3;
                while ((n3 = ((BufferedInputStream)object).read()) != -1) {
                    dataOutputStream.writeByte(n3);
                }
            }
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.mServer.traceError("processGet: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String getHead(String string, String string2) {
        return string + "\nAllow: GET, HEAD, POST\nMIME-Version: 1.0\n" + "Server: " + "HypersonicSQL/1.0" + "\n" + string2 + "\n\n";
    }

    private void processPost(BufferedReader bufferedReader, String string, int n) {
        if (n < 0) {
            this.processError(400);
            return;
        }
        char[] cArray = new char[n];
        try {
            bufferedReader.read(cArray, 0, n);
        }
        catch (IOException iOException) {
            this.processError(400);
            return;
        }
        String string2 = new String(cArray);
        int n2 = string2.indexOf(43);
        int n3 = string2.indexOf(43, n2 + 1);
        if (n2 == -1 || n3 == -1) {
            this.processError(400);
            return;
        }
        String string3 = string2.substring(0, n2);
        string3 = StringConverter.hexStringToUnicode(string3);
        String string4 = string2.substring(n2 + 1, n3);
        string4 = StringConverter.hexStringToUnicode(string4);
        string2 = string2.substring(n3 + 1);
        string2 = StringConverter.hexStringToUnicode(string2);
        this.processQuery(string3, string4, string2);
    }

    private void processError(int n) {
        this.mServer.trace("processError " + n);
        String string = null;
        switch (n) {
            case 400: {
                string = this.getHead("HTTP/1.0 400 Bad Request", "") + "<HTML><BODY><H1>Bad Request</H1>" + "The server could not understand this request.<P></BODY></HTML>";
                break;
            }
            case 404: {
                string = this.getHead("HTTP/1.0 404 Not Found", "") + "<HTML><BODY><H1>Not Found</H1>" + "The server could not find this file.<P></BODY></HTML>";
                break;
            }
            case 403: {
                string = this.getHead("HTTP/1.0 403 Forbidden", "") + "<HTML><BODY><H1>Forbidden</H1>" + "Access is not allowed.<P></BODY></HTML>";
                break;
            }
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            dataOutputStream.write(string.getBytes(ENCODING));
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.mServer.traceError("processError: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void processQuery(String string, String string2, String string3) {
        try {
            this.mServer.trace(string3);
            byte[] byArray = this.mServer.mDatabase.execute(string, string2, string3);
            int n = byArray.length;
            String string4 = this.getHead("HTTP/1.0 200 OK", "Content-Type: application/octet-stream\n" + "Content-Length: " + n);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            dataOutputStream.write(string4.getBytes(ENCODING));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.mServer.traceError("processQuery: " + exception.getMessage());
            exception.printStackTrace();
        }
        if (this.mServer.mDatabase.isShutdown()) {
            this.mServer.trace("The database is shutdown");
            System.exit(0);
        }
    }

    WebServerConnection(Socket socket, WebServer webServer) {
        this.mServer = webServer;
        this.mSocket = socket;
    }
}

