/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.TableDataSet;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Date;

public class TestMySQL {
    static Connection conn;
    private static String DB_NAME;
    private static String DB_TABLE;
    private static String DB_HOST;
    private static String DB_USER;
    private static String DB_PASS;
    private static String DB_DRIVER;
    private static String DB_CONNECTION;
    private static boolean debugging;
    private static int num;
    private static int testCount;
    private static int TDS;
    private static int QDS;
    private static int PASSED;
    private static int FAILED;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray.length < 5) {
            System.out.println("Format: TestMySQL <DB_NAME> <DB_TABLE> <DB_HOST> <DB_USER> <DB_PASS>");
            return;
        }
        if (stringArray.length == 5) {
            DB_NAME = stringArray[0];
            DB_TABLE = stringArray[1];
            DB_HOST = stringArray[2];
            DB_USER = stringArray[3];
            DB_PASS = stringArray[4];
            DB_CONNECTION = "jdbc:mysql://" + DB_HOST + "/" + DB_NAME + "?user=" + DB_USER + "&password=" + DB_PASS;
        }
        TestMySQL.getConnection();
    }

    public static void testDeleteSomeRecords() {
        try {
            KeyDef keyDef = new KeyDef().addAttrib("e");
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            tableDataSet.where("e > 100");
            Record record = tableDataSet.addRecord();
            record.setValue("e", "200");
            Record record2 = tableDataSet.addRecord();
            record2.setValue("e", "300");
            tableDataSet.save();
            tableDataSet.fetchRecords();
            int n = 0;
            while (n < tableDataSet.size()) {
                Record record3 = tableDataSet.getRecord(n);
                record3.markToBeDeleted();
                System.out.println("here " + n + ": " + record3.toString());
                ++n;
            }
            tableDataSet.save();
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void testRemoveRecord() {
        try {
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE);
            tableDataSet.addRecord();
            Record record = tableDataSet.getRecord(0);
            tableDataSet.removeRecord(record);
            Record record2 = tableDataSet.getRecord(0);
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void testTableDataSet2() {
        try {
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE);
            Record record = tableDataSet.addRecord();
            record.setValue("b", 2);
            tableDataSet.save();
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void testTableDataSet3() {
        try {
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE);
            Record record = tableDataSet.addRecord();
            record.setValue("b", 2);
            record.save();
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void testTableDataSet4() {
        try {
            KeyDef keyDef = new KeyDef().addAttrib("b");
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            Record record = tableDataSet.addRecord();
            record.setValueNull("b");
            System.out.println(record.getSaveString());
            record.save();
            record.markToBeDeleted();
            System.out.println(record.getSaveString());
            record.save();
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void testTableDataSet() {
        try {
            KeyDef keyDef = new KeyDef().addAttrib("a");
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            tableDataSet.order("a");
            tableDataSet.fetchRecords();
            int n = tableDataSet.size();
            TestMySQL.debug(TDS, "size of fetchRecords", n);
            TestMySQL.debug(TDS, "getSelectString()", tableDataSet.getSelectString());
            TestMySQL.test(TDS, tableDataSet.getSelectString(), "SELECT * FROM test ORDER BY a");
            Record record = tableDataSet.addRecord();
            record.setValue("a", 1);
            record.setValue("b", 2);
            record.setValue("c", 2343);
            record.setValue("d", 33333);
            record.setValue("e", 22222);
            record.setValue("f", 234324);
            record.setValue("g", 3434);
            record.setValue("h", 2343.3);
            record.setValue("i", 2343.22);
            record.setValue("j", 333.3);
            record.setValue("k", 333.3);
            record.setValue("l", "lskdfsd");
            record.setValue("m", "lksdflkjsldf");
            record.setValue("n", new Date());
            record.setValue("o", new Date());
            record.setValue("p", new Date());
            record.setValue("q", new Date());
            record.setValue("r", "lksdflkjsldf");
            record.setValue("s", "lksdflkjsldf");
            record.setValue("t", "lksdflkjsldf");
            record.setValue("u", "lksdflkjsldf");
            record.setValue("v", "lksdflkjsldf");
            record.setValue("w", "lksdflkjsldf");
            record.setValue("x", "lksdflkjsldf");
            TestMySQL.debug(TDS, "getSaveString() for insert", record.getSaveString());
            TestMySQL.test(TDS, record.getSaveString(), "INSERT INTO test ( a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
            record.save();
            TestMySQL.debug(TDS, "size of TDS after save()", tableDataSet.size());
            TestMySQL.test(TDS, n + 1, tableDataSet.size());
            Record record2 = tableDataSet.getRecord(0);
            record2.setValue("b", 234);
            record2.setValue("c", 4);
            record2.setValue("d", 4);
            record2.setValue("e", 5);
            record2.setValue("f", 6);
            record2.setValue("g", 3);
            record2.setValue("h", 3.4);
            record2.setValue("i", 33.44);
            record2.setValue("j", 33.55);
            record2.setValue("k", 3333.7);
            record2.setValue("l", "qweqwe");
            record2.setValue("m", "qweqwe");
            record2.setValue("n", new Date());
            record2.setValue("o", new Date());
            record2.setValue("p", new Date());
            record2.setValue("q", new Date());
            record2.setValue("r", "qweqwe");
            record2.setValue("s", "qweqwe");
            record2.setValue("t", "qweqwe");
            record2.setValue("u", "qweqwe");
            record2.setValue("v", "qweqwe");
            record2.setValue("w", "qweqwe");
            record2.setValue("x", "qweqwe");
            TestMySQL.debug(TDS, "updateRec.getRefreshQueryString()", record2.getRefreshQueryString());
            TestMySQL.debug(TDS, "updateRec.getSaveString() for update", record2.getSaveString());
            TestMySQL.test(TDS, record2.getSaveString(), "UPDATE test SET b = ?, c = ?, d = ?, e = ?, f = ?, g = ?, h = ?, i = ?, j = ?, k = ?, l = ?, m = ?, n = ?, o = ?, p = ?, q = ?, r = ?, s = ?, t = ?, u = ?, v = ?, w = ?, x = ? WHERE a = ?");
            record2.save();
            record.markToBeDeleted();
            TestMySQL.debug(TDS, "addRec.getSaveString() for delete", record.getSaveString());
            TestMySQL.test(TDS, record.getSaveString(), "DELETE FROM test WHERE a = ?");
            record.save();
            TestMySQL.test(TDS, tableDataSet.size(), 0);
            tableDataSet.close();
            tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            tableDataSet.fetchRecords();
            record = tableDataSet.addRecord();
            record.setValue("a", 1);
            record.save();
            tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            tableDataSet.fetchRecords();
            Record record3 = tableDataSet.getRecord(0);
            TestMySQL.debug(TDS, "getRec.asString() 1a:", record3.getValue("a").asString());
            TestMySQL.test(TDS, record3.getValue("a").asString(), "1");
            TestMySQL.debug(TDS, "getRec.asString() 1b:", record3.getValue("b").asString());
            TestMySQL.test(TDS, record3.getValue("b").asString(), "0");
            record3.setValue("b", 5);
            TestMySQL.debug(TDS, "getRec.asString() 2b:", record3.getValue("b").asString());
            TestMySQL.test(TDS, record3.getValue("b").asString(), "5");
            record3.refresh(conn);
            TestMySQL.debug(TDS, "getRec.asString() 3b:", record3.getValue("b").asString());
            TestMySQL.test(TDS, record3.getValue("b").asString(), "0");
            TestMySQL.debug(TDS, "getRec.asString() 2a:", record3.getValue("a").asString());
            TestMySQL.test(TDS, record3.getValue("a").asString(), "1");
            record3.markToBeDeleted();
            record3.save();
            System.out.println(tableDataSet.toString());
            System.out.println(record3.toString());
            System.out.println(tableDataSet.schema().toString());
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void testQueryDataSet() {
        try {
            KeyDef keyDef = new KeyDef().addAttrib("a");
            TableDataSet tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            tableDataSet.fetchRecords();
            Record record = tableDataSet.addRecord();
            record.setValue("a", 1);
            record.setValue("b", 2);
            TestMySQL.debug(TDS, "addRec.getSaveString()", record.getSaveString());
            TestMySQL.test(TDS, record.getSaveString(), "INSERT INTO test ( a, b ) VALUES ( ?, ? )");
            record.save();
            tableDataSet.close();
            QueryDataSet queryDataSet = new QueryDataSet(conn, "SELECT * FROM " + DB_TABLE);
            queryDataSet.fetchRecords();
            TestMySQL.debug(QDS, "qds.getSelectString()", queryDataSet.getSelectString());
            TestMySQL.test(QDS, queryDataSet.getSelectString(), "SELECT * FROM test");
            TestMySQL.debug(QDS, "qds.size()", queryDataSet.size());
            Record record2 = queryDataSet.getRecord(0);
            TestMySQL.debug(QDS, "rec.size()", record2.size());
            TestMySQL.debug(QDS, "rec.getValue(\"a\").asString()", record2.getValue("a").asString());
            TestMySQL.debug(QDS, "rec.getValue(\"b\").asString()", record2.getValue("b").asString());
            TestMySQL.debug(QDS, "rec.getValue(\"c\").asString()", record2.getValue("c").asString());
            TestMySQL.debug(QDS, "rec.getValue(\"d\").asString()", record2.getValue("d").asString());
            TestMySQL.test(QDS, record2.getValue("d").asString(), "0");
            queryDataSet.close();
            keyDef = new KeyDef().addAttrib("a");
            tableDataSet = new TableDataSet(conn, DB_TABLE, keyDef);
            tableDataSet.fetchRecords();
            Record record3 = tableDataSet.getRecord(0);
            record3.markToBeDeleted();
            record3.save();
            tableDataSet.close();
        }
        catch (Exception exception) {
            TestMySQL.debug(TDS, exception);
        }
    }

    public static void getConnection() {
        try {
            Class.forName(DB_DRIVER);
            conn = DriverManager.getConnection(DB_CONNECTION);
        }
        catch (Exception exception) {
            System.out.println("\n\nConnection failed : " + exception.getMessage());
        }
    }

    public static void debug(int n, Exception exception) {
        TestMySQL.debug(TDS, exception.getMessage());
        exception.printStackTrace();
        System.out.println("\n");
    }

    public static void debug(int n, String string) {
        TestMySQL.debug(n, string, null);
    }

    public static void debug(int n, String string, int n2) {
        new String();
        TestMySQL.debug(n, string, String.valueOf(n2));
    }

    public static void test(int n, int n2, int n3) {
        if (debugging) {
            String string = "";
            string = n == TDS ? "TableDataSet" : "QueryDataSet";
            String string2 = "";
            string2 = n2 == n3 ? "Passed" : "Failed";
            System.out.print("[" + num++ + "] Test " + testCount++ + " - " + string2 + "!\n");
            System.out.flush();
        }
    }

    public static void test(int n, String string, String string2) {
        if (debugging) {
            String string3 = "";
            string3 = n == TDS ? "TableDataSet" : "QueryDataSet";
            String string4 = "";
            string4 = string.equals(string2) ? "Passed" : "Failed";
            System.out.print("[" + num++ + "] Test " + testCount++ + " - " + string4 + "!\n");
            System.out.flush();
        }
    }

    public static void debug(int n, String string, String string2) {
        if (debugging) {
            String string3 = "";
            string3 = n == TDS ? "TableDataSet" : "QueryDataSet";
            if (string2 != null) {
                System.out.print("[" + num++ + "] " + string3 + " - " + string + " = " + string2 + "\n");
            } else {
                System.out.print("[" + num++ + "] " + string3 + " - " + string + "\n");
            }
            System.out.flush();
        }
    }

    static {
        DB_NAME = "village";
        DB_TABLE = "test";
        DB_HOST = "localhost";
        DB_USER = "";
        DB_PASS = "";
        DB_DRIVER = "org.gjt.mm.mysql.Driver";
        DB_CONNECTION = "jdbc:mysql://" + DB_HOST + "/" + DB_NAME + "?user=" + DB_USER + "&password=" + DB_PASS;
        debugging = true;
        num = 1;
        testCount = 1;
        TDS = 1;
        QDS = 2;
        PASSED = 1;
        FAILED = 2;
    }
}

