/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class TemplateNavigation {
    private RunData data;
    private String template;

    public TemplateNavigation(RunData data) {
        this.data = data;
    }

    public TemplateNavigation setTemplate(String template) {
        this.template = template;
        return this;
    }

    public String toString() {
        this.data.getTemplateInfo().setNavigationTemplate(this.template);
        String module = null;
        String returnValue = null;
        try {
            module = ((TemplateService)TurbineServices.getInstance().getService("TemplateService")).getNavigationName(this.template);
            ConcreteElement results = NavigationLoader.getInstance().eval(this.data, module);
            returnValue = results.toString();
        }
        catch (Exception e) {
            String message = "Error processing navigation template:" + this.template + " using module: " + module;
            Log.error(message, e);
            returnValue = message;
        }
        return returnValue;
    }
}

