/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.mail;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailMessage {
    protected String host;
    protected Hashtable headers;
    protected InternetAddress from;
    protected InternetAddress[] replyTo;
    protected InternetAddress[] to;
    protected InternetAddress[] cc;
    protected InternetAddress[] bcc;
    protected String subject;
    protected String body;
    protected boolean debug;

    public MailMessage() {
        this(null, null, null, null, null, "", "", false);
    }

    public MailMessage(String h, String t, String f, String s, String b) {
        this(h, t, null, null, f, s, b, false);
    }

    public MailMessage(String h, String t, String c, String bc, String f, String s, String b, boolean d) {
        this.host = h;
        this.to = t == null ? null : MailMessage.parseAddressField(t);
        this.cc = this.cc == null ? null : MailMessage.parseAddressField(c);
        this.bcc = bc == null ? null : MailMessage.parseAddressField(bc);
        this.from = f == null ? null : MailMessage.parseInternetAddress(f);
        this.subject = s;
        this.body = b;
        this.debug = d;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        this.headers.put(name, value);
    }

    public static InternetAddress[] parseAddressField(String str) {
        String[] addressList;
        if (str.indexOf(",") != -1) {
            Vector<String> v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(str, ",", false);
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
            addressList = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                addressList[i] = (String)v.elementAt(i);
                ++i;
            }
        } else {
            addressList = new String[]{str};
        }
        return MailMessage.parseAddressList(addressList);
    }

    public static InternetAddress[] parseAddressList(String[] aList) {
        InternetAddress[] ia = new InternetAddress[aList.length];
        int i = 0;
        while (i < aList.length) {
            ia[i] = MailMessage.parseInternetAddress(aList[i]);
            ++i;
        }
        return ia;
    }

    public static void parseHeader(String str, Hashtable headers) {
        String name = null;
        String value = null;
        str = str.trim();
        int sp = str.lastIndexOf(":");
        name = str.substring(0, sp);
        value = str.substring(sp + 1).trim();
        headers.put(name, value);
    }

    public static Hashtable parseHeaderField(String str) {
        String[] headerList;
        if (str.indexOf(",") != -1) {
            Vector<String> v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(str, ",", false);
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
            headerList = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                headerList[i] = (String)v.elementAt(i);
                ++i;
            }
        } else {
            headerList = new String[]{str};
        }
        return MailMessage.parseHeaderList(headerList);
    }

    public static Hashtable parseHeaderList(String[] hList) {
        Hashtable headers = new Hashtable();
        int i = 0;
        while (i < hList.length) {
            MailMessage.parseHeader(hList[i], headers);
            ++i;
        }
        return headers;
    }

    public static InternetAddress parseInternetAddress(String str) {
        String address = null;
        String personal = null;
        if ((str = str.trim()).indexOf(" ") == -1) {
            address = str;
        } else {
            int sp = str.lastIndexOf(" ");
            address = str.substring(sp + 1);
            personal = str.substring(0, sp);
        }
        return MailMessage.parseInternetAddress(address, personal);
    }

    public static InternetAddress parseInternetAddress(String address, String personal) {
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(address);
            if (personal != null) {
                ia.setPersonal(personal);
            }
        }
        catch (AddressException e) {
            e.printStackTrace();
            System.out.println();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println();
        }
        return ia;
    }

    public boolean send() {
        Properties props = new Properties();
        ((Hashtable)props).put("mail.smtp.host", this.host);
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(this.debug);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)this.from);
            msg.setRecipients(Message.RecipientType.TO, (Address[])this.to);
            if (this.cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])this.cc);
            }
            if (this.bcc != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])this.bcc);
            }
            if (this.replyTo != null) {
                msg.setReplyTo((Address[])this.replyTo);
            }
            msg.setSubject(this.subject);
            msg.setText(this.body);
            if (this.headers != null) {
                Enumeration e = this.headers.keys();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String value = (String)this.headers.get(name);
                    msg.addHeader(name, value);
                }
            }
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
            Exception ex = null;
            ex = mex.getNextException();
            if (ex != null) {
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public void setBcc(InternetAddress[] bc) {
        this.bcc = bc;
    }

    public void setBcc(String bc) {
        this.bcc = MailMessage.parseAddressField(bc);
    }

    public void setBody(String b) {
        this.body = b;
    }

    public void setCc(InternetAddress[] c) {
        this.cc = c;
    }

    public void setCc(String c) {
        this.cc = MailMessage.parseAddressField(c);
    }

    public void setDebug(String str) {
        this.debug = str.equals("1") ? true : (str.equals("0") ? false : new Boolean(str));
    }

    public void setDebug(boolean d) {
        this.debug = d;
    }

    public void setFrom(String f) {
        this.from = MailMessage.parseInternetAddress(f);
    }

    public void setFrom(InternetAddress f) {
        this.from = f;
    }

    public void setHeaders(String h) {
        this.headers = MailMessage.parseHeaderField(h);
    }

    public void setHeaders(Hashtable h) {
        this.headers = h;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setReplyTo(InternetAddress[] rt) {
        this.replyTo = rt;
    }

    public void setReplyTo(String rp) {
        this.replyTo = MailMessage.parseAddressField(rp);
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setTo(InternetAddress[] t) {
        this.to = t;
    }

    public void setTo(String t) {
        this.to = MailMessage.parseAddressField(t);
    }
}

