/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.stratum.lifecycle.Disposable;
import org.apache.stratum.lifecycle.Initializable;
import org.apache.turbine.Turbine;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class TurbineConfig
implements ServletConfig,
ServletContext,
Initializable,
Disposable {
    private static final boolean DEBUG = false;
    private File root;
    private Map attributes;
    private Map initParams;
    private Turbine turbine;

    public TurbineConfig(String path, Map attributes, Map initParams) {
        this.root = new File(path);
        this.attributes = attributes;
        this.initParams = initParams;
    }

    public TurbineConfig(String path, Map initParams) {
        this(path, new HashMap(0), initParams);
    }

    public TurbineConfig(String path, String properties) {
        this(path, new HashMap(1));
        this.initParams.put("properties", properties);
    }

    public void init() {
        this.initialize();
    }

    public void initialize() {
        try {
            this.turbine = new Turbine();
            this.turbine.init(this);
        }
        catch (Exception e) {
            Log.error("TurbineConfig: Initialization failed", e);
        }
    }

    public void init(RunData data) {
        if (this.turbine != null) {
            this.turbine.init(data);
        }
    }

    public void dispose() {
        if (this.turbine != null) {
            this.turbine.destroy();
        }
    }

    public ServletContext getServletContext() {
        return this;
    }

    public String getRealPath(String path) {
        File f = new File(this.root, path);
        return f.exists() ? f.getPath() : null;
    }

    public String getInitParameter(String name) {
        return (String)this.initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new Vector(this.initParams.keySet()).elements();
    }

    public String getServletName() {
        return "Turbine";
    }

    public String getServletContextName() {
        return "Turbine";
    }

    public URL getResource(String s) throws MalformedURLException {
        return new URL("file://" + this.getRealPath(s));
    }

    public InputStream getResourceAsStream(String s) {
        try {
            FileInputStream fis = new FileInputStream(this.getRealPath(s));
            return new BufferedInputStream(fis);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public void log(Exception e, String m) {
        System.err.println(m);
        e.printStackTrace();
    }

    public void log(String m) {
        System.out.println(m);
    }

    public void log(String m, Throwable t) {
        System.err.println(m);
        t.printStackTrace();
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration getAttributeNames() {
        return new Vector(this.attributes.keySet()).elements();
    }

    public ServletContext getContext(String s) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        throw new UnsupportedOperationException();
    }

    public String getMimeType(String s) {
        throw new UnsupportedOperationException();
    }

    public int getMinorVersion() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    public Set getResourcePaths() {
        throw new UnsupportedOperationException();
    }

    public Set getResourcePaths(String s) {
        throw new UnsupportedOperationException();
    }

    public String getServerInfo() {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String s) {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String s) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String s, Object o) {
        throw new UnsupportedOperationException();
    }
}

