/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequencedHashtable
extends Hashtable {
    private static final int UNKNOWN_INDEX = -1;
    private LinkedList keySequence = new LinkedList();

    public SequencedHashtable() {
    }

    public SequencedHashtable(int size) {
        super(size);
    }

    public synchronized void clear() {
        super.clear();
        this.keySequence.clear();
    }

    public synchronized Object clone() {
        SequencedHashtable seqHash = (SequencedHashtable)super.clone();
        seqHash.keySequence = (LinkedList)this.keySequence.clone();
        return seqHash;
    }

    public Object get(int index) {
        return this.keySequence.get(index);
    }

    public Object getValue(int index) {
        return this.get(this.get(index));
    }

    public int indexOf(Object key) {
        return this.keySequence.indexOf(key);
    }

    public Iterator iterator() {
        return this.keySequence.iterator();
    }

    public int lastIndexOf(Object key) {
        return this.keySequence.lastIndexOf(key);
    }

    public List sequence() {
        return this.keySequence;
    }

    public synchronized Object put(Object key, Object value) {
        Object prevValue = super.put(key, value);
        this.freshenSequence(key, prevValue);
        return prevValue;
    }

    protected void freshenSequence(Object key, Object value) {
        if (value != null) {
            this.keySequence.remove(key);
        }
        this.keySequence.add(key);
    }

    public synchronized void putAll(Map t) {
        Set set = t.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(int index) {
        return this.remove(index, (Object)null);
    }

    public Object remove(Object key) {
        return this.remove(-1, key);
    }

    private final synchronized Object remove(int index, Object key) {
        if (index == -1) {
            index = this.indexOf(key);
        }
        if (key == null) {
            key = this.get(index);
        }
        if (index != -1) {
            this.keySequence.remove(index);
        }
        return super.remove(key);
    }

    public Collection values() {
        return this.keySequence;
    }
}

