/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.html.A;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.parser.BaseValueParser;

public class DynamicURI {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    protected ServerData sd = null;
    protected RunData data = null;
    protected String serverScheme = null;
    protected String serverName = null;
    protected int serverPort = 80;
    protected String scriptName = null;
    protected String reference = null;
    public HttpServletResponse res = null;
    protected Vector pathInfo = null;
    protected Vector queryData = null;
    protected boolean hasPathInfo = false;
    protected boolean hasQueryData = false;
    protected boolean redirect = false;
    protected static final int PATH_INFO = 0;
    protected static final int QUERY_DATA = 1;

    public DynamicURI(RunData data) {
        this.init(data);
    }

    public DynamicURI() {
    }

    public DynamicURI(RunData data, String screen) {
        this(data);
        this.setScreen(screen);
    }

    public DynamicURI(RunData data, String screen, String action) {
        this(data, screen);
        this.setAction(action);
    }

    public DynamicURI(RunData data, String screen, String action, boolean redirect) {
        this(data, screen, action);
        this.redirect = redirect;
    }

    public DynamicURI(RunData data, String screen, boolean redirect) {
        this(data, screen);
        this.redirect = redirect;
    }

    public DynamicURI(RunData data, boolean redirect) {
        this(data);
        this.redirect = redirect;
    }

    public DynamicURI(ServerData sd) {
        this.init(sd);
    }

    public DynamicURI(ServerData sd, String screen) {
        this(sd);
        this.setScreen(screen);
    }

    public DynamicURI(ServerData sd, String screen, String action) {
        this(sd, screen);
        this.setAction(action);
    }

    public DynamicURI(ServerData sd, String screen, String action, boolean redirect) {
        this(sd, screen, action);
        this.redirect = redirect;
    }

    public DynamicURI(ServerData sd, String screen, boolean redirect) {
        this(sd, screen);
        this.redirect = redirect;
    }

    public DynamicURI(ServerData sd, boolean redirect) {
        this(sd);
        this.redirect = redirect;
    }

    public void init(RunData data) {
        this.init(data.getServerData());
        this.data = data;
        this.res = data.getResponse();
    }

    public void init(ServerData sd) {
        this.setServerData(sd);
        this.init();
    }

    protected void add(int type, String name, String value) {
        Object[] tmp = new Object[]{BaseValueParser.convertAndTrim(name), value};
        switch (type) {
            case 0: {
                this.pathInfo.addElement(tmp);
                this.hasPathInfo = true;
                break;
            }
            case 1: {
                this.queryData.addElement(tmp);
                this.hasQueryData = true;
            }
        }
    }

    protected void add(int type, ParameterParser pp) {
        Enumeration e = pp.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equalsIgnoreCase("action") || key.equalsIgnoreCase("screen") || key.equalsIgnoreCase("template")) continue;
            String[] values = pp.getStrings(key);
            int i = 0;
            while (i < values.length) {
                this.add(type, key, values[i]);
                ++i;
            }
        }
    }

    public DynamicURI addPathInfo(String name, Object value) {
        this.add(0, name, value.toString());
        return this;
    }

    public DynamicURI addPathInfo(String name, String value) {
        this.add(0, name, value);
        return this;
    }

    public DynamicURI addPathInfo(String name, double value) {
        this.add(0, name, Double.toString(value));
        return this;
    }

    public DynamicURI addPathInfo(String name, int value) {
        this.add(0, name, new Integer(value).toString());
        return this;
    }

    public DynamicURI addPathInfo(String name, long value) {
        this.add(0, name, new Long(value).toString());
        return this;
    }

    public DynamicURI addPathInfo(ParameterParser pp) {
        this.add(0, pp);
        return this;
    }

    public DynamicURI addQueryData(String name, Object value) {
        this.add(1, name, value.toString());
        return this;
    }

    public DynamicURI addQueryData(String name, String value) {
        this.add(1, name, value);
        return this;
    }

    public DynamicURI addQueryData(String name, double value) {
        this.add(1, name, Double.toString(value));
        return this;
    }

    public DynamicURI addQueryData(String name, int value) {
        this.add(1, name, new Integer(value).toString());
        return this;
    }

    public DynamicURI addQueryData(String name, long value) {
        this.add(1, name, new Long(value).toString());
        return this;
    }

    public DynamicURI addQueryData(ParameterParser pp) {
        this.add(1, pp);
        return this;
    }

    public String getA(String name) {
        return new A(this.toString(), name).toString();
    }

    public String getScriptName() {
        if (this.scriptName == null) {
            return "";
        }
        return this.scriptName;
    }

    public String getReference() {
        if (this.reference == null) {
            return "";
        }
        return this.reference;
    }

    public String getServerName() {
        if (this.serverName == null) {
            return "";
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == 0) {
            return 80;
        }
        return this.serverPort;
    }

    public String getServerScheme() {
        if (this.serverScheme == null) {
            return "";
        }
        return this.serverScheme;
    }

    protected void init() {
        this.serverScheme = this.getServerData().getServerScheme();
        this.serverName = this.getServerData().getServerName();
        this.serverPort = this.getServerData().getServerPort();
        this.scriptName = this.getServerData().getScriptName();
        this.pathInfo = new Vector();
        this.queryData = new Vector();
        this.reference = null;
    }

    protected void remove(int type, String name) {
        try {
            switch (type) {
                case 0: {
                    Enumeration e = this.pathInfo.elements();
                    while (e.hasMoreElements()) {
                        Object[] tmp = (Object[])e.nextElement();
                        if (!BaseValueParser.convertAndTrim(name).equals((String)tmp[0])) continue;
                        this.pathInfo.removeElement(tmp);
                    }
                    if (this.hasPathInfo && this.pathInfo.size() == 0) {
                        this.hasPathInfo = false;
                    }
                    break;
                }
                case 1: {
                    Enumeration e = this.queryData.elements();
                    while (e.hasMoreElements()) {
                        Object[] tmp = (Object[])e.nextElement();
                        if (!BaseValueParser.convertAndTrim(name).equals((String)tmp[0])) continue;
                        this.queryData.removeElement(tmp);
                    }
                    if (this.hasQueryData && this.queryData.size() == 0) {
                        this.hasQueryData = false;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removePathInfo() {
        this.pathInfo.removeAllElements();
        this.hasPathInfo = false;
    }

    public void removePathInfo(String name) {
        this.remove(0, name);
    }

    public void removeQueryData() {
        this.queryData.removeAllElements();
        this.hasQueryData = false;
    }

    public void removeQueryData(String name) {
        this.remove(1, name);
    }

    protected String renderPathInfo(Vector data) {
        String key = null;
        String value = null;
        String tmp = null;
        StringBuffer out = new StringBuffer();
        Enumeration keys = data.elements();
        while (keys.hasMoreElements()) {
            Object[] stuff = (Object[])keys.nextElement();
            key = URLEncoder.encode((String)stuff[0]);
            tmp = (String)stuff[1];
            value = tmp == null || tmp.length() == 0 ? "null" : URLEncoder.encode(tmp);
            if (out.length() > 0) {
                out.append("/");
            }
            out.append(key);
            out.append("/");
            out.append(value);
        }
        return out.toString();
    }

    protected String renderQueryString(Vector data) {
        String key = null;
        String value = null;
        String tmp = null;
        StringBuffer out = new StringBuffer();
        Enumeration keys = data.elements();
        while (keys.hasMoreElements()) {
            Object[] stuff = (Object[])keys.nextElement();
            key = URLEncoder.encode((String)stuff[0]);
            tmp = (String)stuff[1];
            value = tmp == null || tmp.length() == 0 ? "null" : URLEncoder.encode(tmp);
            if (out.length() > 0) {
                out.append("&");
            }
            out.append(key);
            out.append("=");
            out.append(value);
        }
        return out.toString();
    }

    public DynamicURI setAction(String action) {
        this.add(0, "action", action);
        return this;
    }

    public DynamicURI setScreen(String screen) {
        this.add(0, "screen", screen);
        return this;
    }

    public DynamicURI setScriptName(String name) {
        this.scriptName = name;
        return this;
    }

    public DynamicURI setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public DynamicURI setServerName(String name) {
        this.serverName = name;
        return this;
    }

    public DynamicURI setServerPort(int port) {
        this.serverPort = port;
        return this;
    }

    public DynamicURI setSecure() {
        return this.setSecure(443);
    }

    public DynamicURI setSecure(int port) {
        boolean isSSL = TurbineResources.getBoolean("use.ssl", true);
        if (isSSL) {
            this.setServerScheme(HTTPS);
            this.setServerPort(port);
        }
        return this;
    }

    public DynamicURI setServerScheme(String scheme) {
        this.serverScheme = scheme;
        return this;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.getServerScheme());
        output.append("://");
        output.append(this.getServerName());
        if (this.getServerScheme().equals(HTTP) && this.getServerPort() != 80 || this.getServerScheme().equals(HTTPS) && this.getServerPort() != 443) {
            output.append(":");
            output.append(this.getServerPort());
        }
        output.append(this.getScriptName());
        if (this.hasPathInfo) {
            output.append("/");
            output.append(this.renderPathInfo(this.pathInfo));
        }
        if (this.hasQueryData) {
            output.append("?");
            output.append(this.renderQueryString(this.queryData));
        }
        if (this.reference != null) {
            output.append("#");
            output.append(this.getReference());
        }
        if (this.res != null) {
            if (this.redirect) {
                return this.res.encodeRedirectUrl(output.toString());
            }
            return this.res.encodeUrl(output.toString());
        }
        return output.toString();
    }

    public static String toString(RunData data) {
        StringBuffer output = new StringBuffer();
        HttpServletRequest request = data.getRequest();
        output.append(data.getServerScheme());
        output.append("://");
        output.append(data.getServerName());
        if (data.getServerScheme().equals(HTTP) && data.getServerPort() != 80 || data.getServerScheme().equals(HTTPS) && data.getServerPort() != 443) {
            output.append(":");
            output.append(data.getServerPort());
        }
        output.append(data.getServerData().getScriptName());
        if (request.getPathInfo() != null) {
            output.append(request.getPathInfo());
        }
        if (request.getQueryString() != null) {
            output.append("?");
            output.append(request.getQueryString());
        }
        return output.toString();
    }

    public ServerData getServerData() {
        return this.sd;
    }

    public void setServerData(ServerData sd) {
        this.sd = sd;
    }
}

