/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xslt;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.xslt.XSLTService;
import org.w3c.dom.Node;

public class TurbineXSLTService
extends TurbineBaseService
implements XSLTService {
    protected boolean caching = false;
    protected String path;
    protected Hashtable cache = new Hashtable();
    private static TransformerFactory tfactory;

    public void init() {
        if (this.getInit()) {
            return;
        }
        this.path = TurbineResources.getString("services.XSLTService.path");
        this.path = TurbineServlet.getRealPath(this.path);
        if (!this.path.endsWith("/") && !this.path.endsWith("\\")) {
            this.path = this.path + File.separator;
        }
        this.caching = TurbineResources.getBoolean("services.XSLTService.cache");
        tfactory = TransformerFactory.newInstance();
        this.setInit(true);
    }

    protected String getFileName(String templateName) {
        File f;
        int colon = templateName.lastIndexOf(".");
        if (colon > 0) {
            templateName = templateName.substring(0, colon);
        }
        if ((f = new File(this.path + templateName + ".xsl")).exists()) {
            return this.path + templateName + ".xsl";
        }
        f = new File(this.path + "default.xsl");
        if (f.exists()) {
            return this.path + "default.xsl";
        }
        return null;
    }

    protected Templates compileTemplates(String source) throws Exception {
        StreamSource xslin = new StreamSource(new File(source));
        Templates root = tfactory.newTemplates(xslin);
        return root;
    }

    protected Templates getTemplates(String xslName) throws Exception {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            if (this.caching && this.cache.containsKey(xslName)) {
                Templates templates = (Templates)this.cache.get(xslName);
                return templates;
            }
            String fn = this.getFileName(xslName);
            if (fn == null) {
                Templates templates = null;
                return templates;
            }
            Templates sr = this.compileTemplates(fn);
            if (this.caching) {
                this.cache.put(xslName, sr);
            }
            Templates templates = sr;
            return templates;
        }
    }

    protected void transform(String xslName, Source xmlin, Result xmlout) throws Exception {
        Templates sr = this.getTemplates(xslName);
        Transformer transformer = sr == null ? tfactory.newTransformer() : sr.newTransformer();
        transformer.transform(xmlin, xmlout);
    }

    public void transform(String xslName, Reader in, Writer out) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout);
    }

    public String transform(String xslName, Reader in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout);
    }

    public String transform(String xslName, Node in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }
}

