/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc.util;

import java.net.URL;
import java.util.Vector;
import org.apache.turbine.services.xmlrpc.TurbineXmlRpc;
import org.apache.turbine.services.xmlrpc.util.FileHandler;
import org.apache.turbine.util.Log;

public class FileTransfer {
    public static void send(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        try {
            Vector<String> params = new Vector<String>();
            params.add(FileHandler.readFileContents(sourceLocationProperty, sourceFileName));
            params.add(destinationLocationProperty);
            params.add(destinationFileName);
            Boolean b = (Boolean)TurbineXmlRpc.executeRpc(new URL(serverURL), "file.send", params);
        }
        catch (Exception e) {
            Log.error("Error sending file to server:", e);
            throw new Exception(e.toString());
        }
    }

    public static void send(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        try {
            Vector<String> params = new Vector<String>();
            params.add(FileHandler.readFileContents(sourceLocationProperty, sourceFileName));
            params.add(destinationLocationProperty);
            params.add(destinationFileName);
            Boolean b = (Boolean)TurbineXmlRpc.executeAuthenticatedRpc(new URL(serverURL), username, password, "file.send", params);
        }
        catch (Exception e) {
            Log.error("Error sending file to server:", e);
            throw new Exception(e.toString());
        }
    }

    public static void get(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            String fileContents = (String)TurbineXmlRpc.executeRpc(new URL(serverURL), "file.get", params);
            FileHandler.writeFileContents(fileContents, destinationLocationProperty, destinationFileName);
        }
        catch (Exception e) {
            Log.error("Error getting file from server:", e);
            throw new Exception(e.toString());
        }
    }

    public static void get(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws Exception {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            String fileContents = (String)TurbineXmlRpc.executeAuthenticatedRpc(new URL(serverURL), username, password, "file.get", params);
            FileHandler.writeFileContents(fileContents, destinationLocationProperty, destinationFileName);
        }
        catch (Exception e) {
            Log.error("Error getting file from server:", e);
            throw new Exception(e.toString());
        }
    }

    public static void remove(String serverURL, String sourceLocationProperty, String sourceFileName) throws Exception {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            TurbineXmlRpc.executeRpc(new URL(serverURL), "file.remove", params);
        }
        catch (Exception e) {
            Log.error("Error removing file from server:", e);
            throw new Exception(e.toString());
        }
    }

    public static void remove(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName) throws Exception {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            TurbineXmlRpc.executeAuthenticatedRpc(new URL(serverURL), username, password, "file.remove", params);
        }
        catch (Exception e) {
            Log.error("Error removing file from server:", e);
            throw new Exception(e.toString());
        }
    }
}

