/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.resources;

import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public abstract class TurbineResources {
    public static final String MAIL_SERVER_KEY = "mail.server";
    public static final String MODULE_CACHE_KEY = "module.cache";
    public static final String MODULE_PACKAGES_KEY = "module.packages";
    public static final String ACTION_CACHE_SIZE_KEY = "action.cache.size";
    public static final String LAYOUT_CACHE_SIZE_KEY = "layout.cache.size";
    public static final String NAVIGATION_CACHE_SIZE_KEY = "navigation.cache.size";
    public static final String PAGE_CACHE_SIZE_KEY = "page.cache.size";
    public static final String SCREEN_CACHE_SIZE_KEY = "screen.cache.size";
    public static final String USER_CLASS_KEY = "user.class";
    public static final String MAX_FILE_SIZE_KEY = "max.file.size.bytes";
    public static final String DB_DRIVER_KEY = "database.default.driver";
    public static final String DB_URL_KEY = "database.default.url";
    public static final String DB_USERNAME_KEY = "database.default.username";
    public static final String DB_PASSWORD_KEY = "database.default.password";
    public static final String DB_MAXCONNECTIONS_KEY = "database.maxConnections";
    public static final String DB_EXPIRYTIME_KEY = "database.expiryTime";
    public static final String FILE_SERVER = "file.server";
    public static final String LOGIN_MESSAGE = "login.message";
    public static final String LOGIN_ERROR = "login.error";
    public static final String LOGIN_MESSAGE_NOSCREEN = "login.message.noscreen";
    public static final String LOGOUT_MESSAGE = "logout.message";
    public static final String DB_IDBROKER_CLEVERQUANTITY = "database.idbroker.cleverquantity";
    public static final String DB_IDBROKER_PREFETCH = "database.idbroker.prefetch";

    protected static ResourceService getService() {
        return (ResourceService)TurbineServices.getInstance().getService("ResourceService");
    }

    public static void setProperty(String key, String value) {
        TurbineResources.getService().setProperty(key, value);
    }

    public static boolean getBoolean(String name) {
        return TurbineResources.getService().getBoolean(name);
    }

    public static boolean getBoolean(String name, boolean def) {
        return TurbineResources.getService().getBoolean(name, def);
    }

    public static double getDouble(String name) {
        return TurbineResources.getService().getDouble(name);
    }

    public static double getDouble(String name, double def) {
        return TurbineResources.getService().getDouble(name, def);
    }

    public static float getFloat(String name) {
        return TurbineResources.getService().getFloat(name);
    }

    public static float getFloat(String name, float def) {
        return TurbineResources.getService().getFloat(name, def);
    }

    public static int getInt(String name) {
        return TurbineResources.getService().getInt(name);
    }

    public static int getInt(String name, int def) {
        return TurbineResources.getService().getInt(name, def);
    }

    public static Iterator getKeys() {
        return TurbineResources.getService().getKeys();
    }

    public static Iterator getKeys(String prefix) {
        return TurbineResources.getService().getKeys(prefix);
    }

    public static long getLong(String name) {
        return TurbineResources.getService().getLong(name);
    }

    public static long getLong(String name, long def) {
        return TurbineResources.getService().getLong(name, def);
    }

    public static String getString(String name) {
        return TurbineResources.getService().getString(name);
    }

    public static String getString(String name, String def) {
        return TurbineResources.getService().getString(name, def);
    }

    public static String[] getStringArray(String name) {
        return TurbineResources.getService().getStringArray(name);
    }

    public static Vector getVector(String name) {
        return TurbineResources.getService().getVector(name);
    }

    public static Vector getVector(String name, Vector def) {
        return TurbineResources.getService().getVector(name, def);
    }

    public static ResourceService getResources(String prefix) {
        return TurbineResources.getService().getResources(prefix);
    }

    public static Configuration getConfiguration() {
        return TurbineResources.getService().getConfiguration();
    }

    public static Configuration getConfiguration(String prefix) {
        return TurbineResources.getService().getConfiguration(prefix);
    }
}

