/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import org.apache.turbine.services.logging.BaseRunDataFilter;
import org.apache.turbine.services.logging.Logger;
import org.apache.turbine.services.logging.LoggingConfig;
import org.apache.turbine.services.logging.RunDataFilter;
import org.apache.turbine.util.RunData;

public abstract class BaseLogger
implements Logger {
    protected int logLevel = 1;
    protected String name = null;
    protected boolean initialize = false;
    protected RunDataFilter runDataFilter = new BaseRunDataFilter();
    protected LoggingConfig loggingConfig = null;
    protected boolean console = false;

    public void init(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
        this.doBaseInit(loggingConfig);
        this.doDispatch(loggingConfig);
    }

    private void doBaseInit(LoggingConfig loggingConfig) {
        this.setName(loggingConfig.getName());
        this.setLogLevel(loggingConfig.getLevel());
        this.setFormat(loggingConfig.getFormat());
    }

    protected void doDispatch(LoggingConfig loggingConfig) {
        this.configureFiles(loggingConfig);
        this.configureConsole(loggingConfig);
        this.configureRemote(loggingConfig);
        this.configureSyslog(loggingConfig);
        this.configureEmail(loggingConfig);
        this.configureDatabase(loggingConfig);
        this.initialize = this.checkLogger();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String logName) {
        this.name = logName;
    }

    public void setFormat(String format) {
        this.runDataFilter.setFormat(format);
    }

    protected void setLogLevel(String level) {
        if (level != null && !level.trim().equals("")) {
            int newLevel = 1;
            if ((level = level.toUpperCase()).equals("INFO")) {
                newLevel = 2;
            } else if (level.equals("WARN")) {
                newLevel = 3;
            } else if (level.equals("ERROR")) {
                newLevel = 4;
            }
            this.setLogLevel(newLevel);
        }
    }

    public void setLogLevel(int level) {
        if (level < 1) {
            level = 1;
        } else if (level > 4) {
            level = 4;
        }
        this.logLevel = level;
    }

    public boolean isDebugEnabled() {
        return this.logLevel == 1;
    }

    public boolean isInfoEnabled() {
        return this.logLevel <= 2;
    }

    public boolean isWarnEnabled() {
        return this.logLevel <= 3;
    }

    public boolean isErrorEnabled() {
        return this.logLevel <= 4;
    }

    protected void configureFiles(LoggingConfig loggingConfig) {
    }

    protected void configureConsole(LoggingConfig loggingConfig) {
    }

    protected void configureRemote(LoggingConfig loggingConfig) {
    }

    protected void configureSyslog(LoggingConfig loggingConfig) {
    }

    protected void configureEmail(LoggingConfig loggingConfig) {
    }

    protected void configureDatabase(LoggingConfig loggingConfig) {
    }

    public abstract boolean checkLogger();

    public abstract void error(String var1, RunData var2, Throwable var3);

    public abstract void error(String var1, RunData var2);

    public abstract void error(Throwable var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void warn(String var1, RunData var2, Throwable var3);

    public abstract void warn(String var1, RunData var2);

    public abstract void warn(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void info(String var1, RunData var2, Throwable var3);

    public abstract void info(String var1, RunData var2);

    public abstract void info(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void debug(String var1, RunData var2, Throwable var3);

    public abstract void debug(String var1, RunData var2);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(String var1);

    public abstract void shutdown();
}

