/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.localization.LocaleTokenizer;
import org.apache.turbine.services.localization.LocalizationService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class TurbineLocalizationService
extends TurbineBaseService
implements LocalizationService {
    private Hashtable bundles = new Hashtable();
    private String[] bundleNames = null;
    private Locale defaultLocale = null;
    private String defaultLanguage = null;
    private String defaultCountry = null;

    public void init() throws InitializationException {
        this.initBundleNames(null);
        Locale jvmDefault = Locale.getDefault();
        this.defaultLanguage = TurbineResources.getString("locale.default.language", jvmDefault.getLanguage()).trim();
        this.defaultCountry = TurbineResources.getString("locale.default.country", jvmDefault.getCountry()).trim();
        this.defaultLocale = new Locale(this.defaultLanguage, this.defaultCountry);
        this.setInit(true);
    }

    protected void initBundleNames(String[] ignored) {
        this.bundleNames = TurbineResources.getStringArray("locale.default.bundles");
        String name = TurbineResources.getString("locale.default.bundle");
        if (name != null && name.length() > 0) {
            if (this.bundleNames == null || this.bundleNames.length <= 0) {
                this.bundleNames = new String[]{name};
            } else {
                String[] array = new String[this.bundleNames.length + 1];
                array[0] = name;
                System.arraycopy(this.bundleNames, 0, array, 1, this.bundleNames.length);
                this.bundleNames = array;
            }
        }
        if (this.bundleNames == null) {
            this.bundleNames = new String[0];
        }
    }

    public String getDefaultBundleName() {
        return this.bundleNames.length > 0 ? this.bundleNames[0] : "";
    }

    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), (Locale)null);
    }

    public ResourceBundle getBundle(String bundleName) {
        return this.getBundle(bundleName, (Locale)null);
    }

    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    public ResourceBundle getBundle(HttpServletRequest req) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(req));
    }

    public ResourceBundle getBundle(String bundleName, HttpServletRequest req) {
        return this.getBundle(bundleName, this.getLocale(req));
    }

    public ResourceBundle getBundle(RunData data) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(data.getRequest()));
    }

    public ResourceBundle getBundle(String bundleName, RunData data) {
        return this.getBundle(bundleName, this.getLocale(data.getRequest()));
    }

    public ResourceBundle getBundle(String bundleName, Locale locale) {
        String string = bundleName = bundleName == null ? this.getDefaultBundleName() : bundleName.trim();
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        if (this.bundles.containsKey(bundleName)) {
            Hashtable locales = (Hashtable)this.bundles.get(bundleName);
            if (locales.containsKey(locale)) {
                return (ResourceBundle)locales.get(locale);
            }
            ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
            locales.put(rb.getLocale(), rb);
            return rb;
        }
        ResourceBundle rb = ResourceBundle.getBundle(bundleName, locale);
        Hashtable<Locale, ResourceBundle> ht = new Hashtable<Locale, ResourceBundle>();
        ht.put(locale, rb);
        this.bundles.put(bundleName, ht);
        return rb;
    }

    public void setBundle(String defaultBundle) {
        if (this.bundleNames.length > 0) {
            this.bundleNames[0] = defaultBundle;
        } else {
            TurbineLocalizationService turbineLocalizationService = this;
            synchronized (turbineLocalizationService) {
                if (this.bundleNames.length <= 0) {
                    this.bundleNames = new String[]{defaultBundle};
                }
            }
        }
    }

    public final Locale getLocale(HttpServletRequest req) {
        return this.getLocale(req.getHeader("Accept-Language"));
    }

    public Locale getLocale(String header) {
        LocaleTokenizer tok;
        if (!StringUtils.isEmpty(header) && (tok = new LocaleTokenizer(header)).hasNext()) {
            return (Locale)tok.next();
        }
        return this.defaultLocale;
    }

    public String getString(String bundleName, Locale locale, String key) {
        ResourceBundle rb;
        String value = null;
        if (locale == null) {
            locale = this.getLocale((String)null);
        }
        if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null && this.bundleNames.length > 0) {
            int i = 0;
            while (i < this.bundleNames.length) {
                String name = this.bundleNames[i];
                if (!name.equals(bundleName) && (value = this.getStringOrNull(rb = this.getBundle(name, locale), key)) != null) {
                    locale = rb.getLocale();
                    break;
                }
                ++i;
            }
        }
        if (value == null) {
            String loc = locale.toString();
            Log.debug("LocalizationService noticed missing resource: bundleName=" + bundleName + ", locale=" + loc + ", key=" + key);
            throw new MissingResourceException(bundleName, loc, key);
        }
        return value;
    }

    protected final String getStringOrNull(ResourceBundle rb, String key) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }
}

