/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.xmlmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.turbine.services.intake.xmlmodel.Rule;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.apache.turbine.util.StringUtils;
import org.xml.sax.Attributes;

public class XmlField
implements Serializable {
    private static final String DEFAULT_VALIDATOR = "org.apache.turbine.services.intake.validator.DefaultValidator";
    private String baseClass;
    private String name;
    private String key;
    private String type;
    private String displayName;
    private String onError;
    private String multiValued;
    private XmlGroup parent;
    private List rules;
    private Map ruleMap;
    private String ifRequiredMessage;
    private String mapToObject;
    private String mapToProperty;
    private String validator;
    private String defaultValue;
    private static HashMap defaultOnErrors;
    private static HashMap convertHash;
    private static HashMap convertArrayHash;

    private static void populateDefaults() {
        defaultOnErrors = new HashMap(15);
        convertHash = new HashMap(15);
        convertArrayHash = new HashMap(15);
        defaultOnErrors.put("boolean", "false");
        defaultOnErrors.put("byte", "-1");
        defaultOnErrors.put("short", "-1");
        defaultOnErrors.put("int", "-1");
        defaultOnErrors.put("long", "-1");
        defaultOnErrors.put("float", "-1.0f");
        defaultOnErrors.put("double", "-1.0");
        defaultOnErrors.put("BigDecimal", "new BigDecimal(\"-1.0\")");
        convertHash.put("boolean", "getBoolean");
        convertHash.put("byte", "getByte");
        convertHash.put("short", "getShort");
        convertHash.put("int", "getInt");
        convertHash.put("long", "getLong");
        convertHash.put("float", "getFloat");
        convertHash.put("double", "getDouble");
        convertHash.put("Date", "getDate");
        convertHash.put("BigDecimal", "getBigDecimal");
        convertHash.put("boolean[]", "Boolean.valueOf(stringValue[i]).booleanValue()");
        convertArrayHash.put("byte[]", "Byte.valueOf(stringValue[i]).byteValue()");
        convertArrayHash.put("short[]", "Short.valueOf(stringValue[i]).shortValue()");
        convertArrayHash.put("int[]", "Integer.parseInt(stringValue[i])");
        convertArrayHash.put("long[]", "Long.parseLong(stringValue[i])");
        convertArrayHash.put("float[]", "Float.valueOf(stringValue[i]).floatValue()");
        convertArrayHash.put("double[]", "Double.valueOf(stringValue[i]).doubleValue()");
        convertArrayHash.put("Date[]", "FIXME!!");
        convertArrayHash.put("BigDecimal[]", "new BigDecimal(stringValue[i])");
    }

    public XmlField() {
        XmlField.populateDefaults();
        this.rules = new ArrayList();
        this.ruleMap = new HashMap();
    }

    public XmlField(String name) {
        XmlField.populateDefaults();
        this.name = name;
        this.rules = new ArrayList();
        this.ruleMap = new HashMap();
    }

    public void loadFromXML(Attributes attrib) {
        String mapProp;
        this.setBaseClass(attrib.getValue("baseClass"));
        this.setName(attrib.getValue("name"));
        this.key = attrib.getValue("key");
        this.type = attrib.getValue("type");
        this.displayName = attrib.getValue("displayName");
        this.setMultiValued(attrib.getValue("multiValued"));
        String mapObj = attrib.getValue("mapToObject");
        if (mapObj != null && mapObj.length() != 0) {
            this.setMapToObject(mapObj);
        }
        if ((mapProp = attrib.getValue("mapToProperty")) != null) {
            this.setMapToProperty(mapProp);
        }
        this.setValidator(attrib.getValue("validator"));
        this.setDefaultValue(attrib.getValue("defaultValue"));
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        return StringUtils.removeUnderScores(this.name);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getType() {
        return this.type;
    }

    public void setBaseClass(String newBaseClass) {
        this.baseClass = newBaseClass;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setMultiValued(String newMultiValued) {
        this.multiValued = newMultiValued;
    }

    public boolean isMultiValued() {
        return this.multiValued != null && this.multiValued.equals("true");
    }

    public void setMapToObject(String obj) {
        this.mapToObject = obj;
    }

    public String getMapToObject() {
        return this.mapToObject;
    }

    public void setMapToProperty(String prop) {
        this.mapToProperty = prop;
    }

    public String getMapToProperty() {
        if (this.mapToProperty == null) {
            return this.getName();
        }
        return this.mapToProperty;
    }

    public void setValidator(String prop) {
        this.validator = prop;
    }

    public String getValidator() {
        return this.validator;
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getVariable() {
        String firstChar = this.getName().substring(0, 1).toLowerCase();
        return firstChar + this.getName().substring(1);
    }

    public String getPPMethod() {
        String result = null;
        if (convertHash.containsKey(this.getType())) {
            result = (String)convertHash.get(this.getType());
        }
        return result;
    }

    public String getArrayConvert() {
        String result = null;
        if (convertArrayHash.containsKey(this.getType())) {
            result = (String)convertArrayHash.get(this.getType());
        }
        return result;
    }

    public void setGroup(XmlGroup parent) {
        this.parent = parent;
        if (this.mapToObject != null && this.mapToObject.length() != 0) {
            this.mapToObject = parent.getAppData().getBasePackage() + this.mapToObject;
        }
    }

    public XmlGroup getGroup() {
        return this.parent;
    }

    public String getIfRequiredMessage() {
        return this.ifRequiredMessage;
    }

    public void setIfRequiredMessage(String v) {
        this.ifRequiredMessage = v;
    }

    public Rule addRule(Attributes attrib) {
        Rule rule = new Rule();
        rule.loadFromXML(attrib);
        this.addRule(rule);
        return rule;
    }

    public void addRule(Rule rule) {
        rule.setField(this);
        this.rules.add(rule);
        this.ruleMap.put(rule.getName(), rule);
    }

    public List getRules() {
        return this.rules;
    }

    public Map getRuleMap() {
        return this.ruleMap;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" <field name=\"" + this.name + "\"");
        result.append(" key=\"" + this.key + "\"");
        result.append(" type=\"" + this.type + "\"");
        if (this.displayName != null) {
            result.append(" displayName=\"" + this.displayName + "\"");
        }
        if (this.onError != null) {
            result.append(" onError=\"" + this.onError + "\"");
        }
        if (this.mapToObject != null) {
            result.append(" mapToObject=\"" + this.mapToObject + "\"");
        }
        if (this.mapToProperty != null) {
            result.append(" mapToProperty=\"" + this.mapToProperty + "\"");
        }
        if (this.validator != null) {
            result.append(" validator=\"" + this.validator + "\"");
        }
        if (this.defaultValue != null) {
            result.append(" defaultValue=\"" + this.defaultValue + "\"");
        }
        if (this.rules.size() == 0) {
            result.append(" />\n");
        } else {
            result.append(">\n");
            Iterator i = this.rules.iterator();
            while (i.hasNext()) {
                result.append(i.next());
            }
            result.append("</field>\n");
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        XmlField.populateDefaults();
    }
}

