/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.FileValidator;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.upload.FileItem;

public class FileItemField
extends Field {
    public FileItemField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    protected String getDefaultValidator() {
        return "org.apache.turbine.services.intake.validator.FileValidator";
    }

    public Field init(RunData data) throws TurbineException {
        this.data = data;
        this.valid_flag = true;
        ParameterParser pp = data.getParameters();
        if (pp.containsKey(this.getKey())) {
            this.set_flag = true;
            this.validate(pp);
        }
        this.initialized = true;
        return this;
    }

    protected boolean validate(ParameterParser pp) {
        if (this.isMultiValued) {
            FileItem[] ss = pp.getFileItems(this.getKey());
            if (ss.length == 0) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                int i = 0;
                while (i < ss.length) {
                    try {
                        ((FileValidator)this.validator).assertValidity(ss[i]);
                    }
                    catch (ValidationException ve) {
                        this.setMessage(ve.getMessage());
                    }
                    ++i;
                }
            }
            if (this.set_flag && this.valid_flag) {
                this.doSetValue(pp);
            }
        } else {
            FileItem s = pp.getFileItem(this.getKey());
            if (s == null || s.getSize() == 0L) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                try {
                    ((FileValidator)this.validator).assertValidity(s);
                    if (this.set_flag) {
                        this.doSetValue(pp);
                    }
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            } else if (this.set_flag) {
                this.doSetValue(pp);
            }
        }
        return this.valid_flag;
    }

    protected void doSetValue(ParameterParser pp) {
        if (this.isMultiValued) {
            this.setTestValue(pp.getFileItems(this.getKey()));
        } else {
            this.setTestValue(pp.getFileItem(this.getKey()));
        }
    }
}

