/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.freemarker;

import freemarker.template.CacheEvent;
import freemarker.template.CacheListener;
import freemarker.template.FileTemplateCache;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleList;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelRoot;
import freemarker.template.TemplateServletUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.freemarker.AddTemplatesToHeadModel;
import org.apache.turbine.services.freemarker.AddToHeadModel;
import org.apache.turbine.services.freemarker.DynamicURIModel;
import org.apache.turbine.services.freemarker.FreeMarkerService;
import org.apache.turbine.services.freemarker.SetBodyAttributesModel;
import org.apache.turbine.services.freemarker.SetTitleModel;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class TurbineFreeMarkerService
extends TurbineBaseService
implements FreeMarkerService,
CacheListener {
    private FileTemplateCache templateCache;
    private String path;

    public void init() throws InitializationException {
        try {
            this.initFreeMarker();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineFreeMarkerService failed to initialize", e);
        }
    }

    public SimpleHash getContext() {
        return new SimpleHash();
    }

    public SimpleHash getContext(ServletRequest req) {
        return (SimpleHash)TemplateServletUtils.copyRequest((ServletRequest)req);
    }

    public SimpleHash getContext(RunData data) {
        int i;
        SimpleHash modelRoot = new SimpleHash();
        SimpleHash modelLinks = new SimpleHash();
        modelRoot.put("link", (TemplateModel)new DynamicURIModel(data));
        modelRoot.put("links", (TemplateModel)modelLinks);
        if (data.getUser() != null && data.getUser().hasLoggedIn()) {
            modelRoot.put("loginout_link", new DynamicURI(data, "Login", "LogoutUser").toString());
            modelRoot.put("loginout_text", "Logout");
        } else {
            modelRoot.put("loginout_link", new DynamicURI(data, "Login").toString());
            modelRoot.put("loginout_text", "Login");
        }
        SimpleHash modelData = new SimpleHash();
        SimpleHash modelParameters = new SimpleHash();
        SimpleHash modelACL = new SimpleHash();
        SimpleHash modelRoles = new SimpleHash();
        SimpleHash modelPermissions = new SimpleHash();
        modelRoot.put("data", (TemplateModel)modelData);
        modelData.put("parameters", (TemplateModel)modelParameters);
        modelData.put("acl", (TemplateModel)modelACL);
        modelACL.put("roles", (TemplateModel)modelRoles);
        modelACL.put("permissions", (TemplateModel)modelPermissions);
        modelData.put("serverName", data.getServerName());
        modelData.put("serverPort", String.valueOf(data.getServerPort()));
        modelData.put("serverScheme", data.getServerScheme());
        modelData.put("scriptName", data.getScriptName());
        modelData.put("screen", data.getScreen());
        modelData.put("action", data.getAction());
        modelData.put("title", data.getTitle());
        modelData.put("message", data.getMessage());
        ParameterParser params = data.getParameters();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] values = params.getStrings(key);
            if (values.length == 1) {
                modelParameters.put(key, values[0]);
                continue;
            }
            SimpleList listModel = new SimpleList();
            modelParameters.put(key, (TemplateModel)listModel);
            i = 0;
            while (i < values.length) {
                listModel.add(values[i]);
                ++i;
            }
        }
        if (data.getACL() != null) {
            Iterator roles = data.getACL().getRoles().elements();
            while (roles.hasNext()) {
                String key = ((Role)roles.next()).getName();
                modelRoles.put(key, true);
            }
            Iterator permissions = data.getACL().getPermissions().elements();
            while (permissions.hasNext()) {
                String key = ((Permission)permissions.next()).getName();
                modelPermissions.put(key, true);
            }
        }
        modelRoot.put("setTitle", (TemplateModel)new SetTitleModel(data));
        modelRoot.put("addToHead", (TemplateModel)new AddToHeadModel(data));
        modelRoot.put("addTemplatesToHead", (TemplateModel)new AddTemplatesToHeadModel(data));
        modelRoot.put("setBodyAttributes", (TemplateModel)new SetBodyAttributesModel(data));
        String templatePath = params.getString("template", null);
        if (templatePath != null) {
            StringTokenizer st = new StringTokenizer(templatePath, "/");
            int max = st.countTokens() - 1;
            i = 0;
            while (i < max) {
                modelRoot.put("template_path_" + (i + 1), st.nextToken());
                ++i;
            }
        }
        return modelRoot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String handleRequest(SimpleHash context, String filename, boolean cache) throws TurbineException {
        String results = null;
        StringWriter sw = null;
        PrintWriter out = null;
        try {
            try {
                sw = new StringWriter();
                out = new PrintWriter(sw);
                Template template = null;
                template = cache ? this.getCachedTemplate(filename) : this.getNonCachedTemplate(filename);
                template.process((TemplateModelRoot)context, out);
                results = sw.toString();
            }
            catch (Exception e) {
                throw new TurbineException("Error encountered processing a template: " + filename, e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (out != null) {
                    out.close();
                }
                if (sw == null) throw throwable;
                sw.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (out != null) {
            out.close();
        }
        if (sw == null) return results;
        sw.close();
        return results;
    }

    public String getBasePath() {
        return this.path;
    }

    public Template getCachedTemplate(String templateName) {
        Template template = this.templateCache.getTemplate(templateName);
        return template;
    }

    public Template getNonCachedTemplate(String templateName) throws IOException {
        File file = new File(this.path, templateName = templateName.replace('/', File.separatorChar));
        if (file.canRead()) {
            return new Template(file);
        }
        return null;
    }

    private void initFreeMarker() throws Exception {
        Configuration config = this.getConfiguration();
        this.path = config.getString("templates", "/templates");
        this.path = TurbineServlet.getRealPath(this.path);
        config.setProperty("templates", (Object)this.path);
        this.templateCache = new FileTemplateCache(this.path);
        this.templateCache.addCacheListener((CacheListener)this);
        this.templateCache.startAutoUpdate();
    }

    public void cacheUnavailable(CacheEvent e) {
        Log.error("Cache unavailable: " + e.getException().toString());
    }

    public void elementUpdated(CacheEvent e) {
        Log.info("Template updated: " + e.getElementName());
    }

    public void elementUpdateFailed(CacheEvent e) {
        Log.error("Update of template " + e.getElementName() + " failed: " + e.getException().toString());
    }

    public void elementRemoved(CacheEvent e) {
        Log.warn("Template removed: " + e.getElementName());
    }
}

