/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.freemarker;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

public class DynamicURIModel
implements TemplateMethodModel {
    private RunData data;

    public DynamicURIModel(RunData data) {
        this.data = data;
    }

    public TemplateModel exec(List args) throws TemplateModelException {
        DynamicURI uri = new DynamicURI(this.data);
        String firstArg = (String)args.get(0);
        int start = 1;
        if (firstArg.startsWith("http")) {
            int colonPosition = firstArg.indexOf(58);
            if (colonPosition == -1) {
                uri.setServerScheme(firstArg);
            } else {
                uri.setServerScheme(firstArg.substring(0, colonPosition));
                int secondColonPosition = firstArg.indexOf(58, colonPosition + 1);
                if (secondColonPosition == -1) {
                    uri.setServerName(firstArg.substring(colonPosition + 3));
                } else {
                    uri.setServerName(firstArg.substring(colonPosition + 3, secondColonPosition));
                    uri.setServerPort(Integer.parseInt(firstArg.substring(secondColonPosition + 1)));
                }
            }
            uri.addPathInfo("template", (String)args.get(1));
            start = 2;
        } else {
            uri.addPathInfo("template", firstArg.replace('/', ','));
        }
        boolean firstOfPair = true;
        boolean queryData = false;
        String first = null;
        int i = start;
        while (i < args.size()) {
            String tempArg = (String)args.get(i);
            if (firstOfPair) {
                if (tempArg.equals("?")) {
                    queryData = true;
                } else {
                    first = tempArg;
                    firstOfPair = false;
                }
            } else {
                if (queryData) {
                    uri.addQueryData(first, tempArg);
                } else {
                    uri.addPathInfo(first, tempArg);
                }
                firstOfPair = true;
            }
            ++i;
        }
        return new SimpleScalar(uri.toString());
    }

    public boolean isEmpty() {
        return false;
    }
}

