/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.freemarker;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.apache.ecs.html.Head;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.freemarker.FreeMarkerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class AddTemplatesToHeadModel
implements TemplateMethodModel {
    private RunData data;

    public AddTemplatesToHeadModel(RunData data) {
        this.data = data;
    }

    public TemplateModel exec(List args) throws TemplateModelException {
        Head head = this.data.getPage().getHead();
        String returnValue = "";
        String serviceName = TurbineResources.getString("services.freemarker");
        FreeMarkerService fm = (FreeMarkerService)TurbineServices.getInstance().getService(serviceName);
        SimpleHash context = fm.getContext(this.data);
        int i = 0;
        while (i < args.size()) {
            String name = (String)args.get(i);
            try {
                head.addElement(fm.handleRequest(context, name, true));
                head.addElement("\n");
            }
            catch (TurbineException te) {
                Log.error(te);
                throw new TemplateModelException("An error occured while rendering template " + name + ":\n" + te);
            }
            ++i;
        }
        return new SimpleScalar(returnValue);
    }

    public boolean isEmpty() {
        return false;
    }
}

