/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.turbine.modules.screens.VelocityScreen;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class VelocityDirectScreen
extends VelocityScreen {
    public ConcreteElement buildTemplate(RunData data) throws Exception {
        StringElement output = new StringElement();
        String screenData = null;
        Context context = TurbineVelocity.getContext(data);
        String templateName = TurbineTemplate.getScreenTemplateName(data.getTemplateInfo().getScreenTemplate());
        if (templateName.length() > 0 && templateName.charAt(0) != '/') {
            templateName = '/' + templateName;
        }
        try {
            if (this.getLayout(data) == null) {
                TurbineVelocity.handleRequest(context, "screens" + templateName, (OutputStream)data.getResponse().getOutputStream());
            } else {
                TurbineVelocity.handleRequest(context, "screens" + templateName, data.getOut());
            }
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)StringUtils.stackTrace(e));
            templateName = TurbineResources.getString("template.error", "/error.vm");
            if (templateName.length() > 0 && templateName.charAt(0) != '/') {
                templateName = '/' + templateName;
            }
            TurbineVelocity.handleRequest(context, "screens" + templateName, data.getOut());
        }
        if (screenData != null) {
            output.setFilterState(false);
            output.addElement(screenData);
        }
        return output;
    }
}

