/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.pages;

import java.util.Vector;
import org.apache.ecs.Doctype;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.LayoutLoader;
import org.apache.turbine.modules.Page;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class DefaultPage
extends Page {
    public void doBuild(RunData data) throws Exception {
        this.doBuildBeforeAction(data);
        if (data.hasAction()) {
            ActionLoader.getInstance().exec(data, data.getAction());
        }
        if (data.getRedirectURI() != null && data.getRedirectURI().length() > 0) {
            return;
        }
        this.setDefaultDoctype(data);
        this.doBuildAfterAction(data);
        ScreenLoader sl = ScreenLoader.getInstance();
        Screen aScreen = sl.getInstance(data.getScreen());
        String layout = aScreen.getLayout(data);
        if (layout != null) {
            LayoutLoader.getInstance().exec(data, layout);
        } else {
            ScreenLoader.getInstance().exec(data, data.getScreen());
        }
        this.doPostBuild(data);
    }

    protected void doBuildBeforeAction(RunData data) throws Exception {
    }

    protected void doBuildAfterAction(RunData data) throws Exception {
    }

    protected void doPostBuild(RunData data) throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDefaultDoctype(RunData data) throws Exception {
        String errMsg = "default.doctype property not set properly in TurbineResources.";
        Vector doctypeProperty = TurbineResources.getVector("default.doctype", null);
        if (doctypeProperty == null) return;
        if (doctypeProperty.size() <= 0) return;
        if (doctypeProperty.size() == 1) {
            String doc = (String)doctypeProperty.firstElement();
            if (doc.equalsIgnoreCase("Html40Transitional")) {
                data.getPage().setDoctype((Doctype)new Doctype.Html40Transitional());
                return;
            } else if (doc.equalsIgnoreCase("Html40Strict")) {
                data.getPage().setDoctype((Doctype)new Doctype.Html40Strict());
                return;
            } else {
                if (!doc.equalsIgnoreCase("Html40Frameset")) throw new Exception(errMsg);
                data.getPage().setDoctype((Doctype)new Doctype.Html40Frameset());
            }
            return;
        } else {
            if (doctypeProperty.size() != 2) throw new Exception(errMsg);
            data.getPage().setDoctype(new Doctype().setIdentifier((String)doctypeProperty.elementAt(0)).setUri((String)doctypeProperty.elementAt(1)));
        }
    }
}

