/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class DefaultSessionValidator
extends SessionValidator {
    public void doPerform(RunData data) throws Exception {
        data.populate();
        if (data.getUser() == null || !data.getUser().hasLoggedIn()) {
            if (data.getMessage() == null) {
                data.setMessage(TurbineResources.getString("login.message"));
            }
            data.setScreen(TurbineResources.getString("screen.login"));
            data.setAction(null);
        } else if (!data.hasScreen()) {
            data.setMessage(TurbineResources.getString("login.message.noscreen"));
            data.setScreen(TurbineResources.getString("screen.homepage"));
        } else if (data.getParameters().containsKey("_session_access_counter") && data.getParameters().getInt("_session_access_counter") < (Integer)data.getUser().getTemp("_session_access_counter") - 1) {
            data.getUser().setTemp("prev_screen", data.getScreen());
            data.getUser().setTemp("prev_parameters", data.getParameters());
            data.setScreen(TurbineResources.getString("screen.invalidstate"));
            data.setAction("");
        }
    }
}

