/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import freemarker.template.SimpleScalar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.freemarker.DynamicURIModel;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class FreeMarkerSiteCooker
extends Action {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPerform(RunData data) throws Exception {
        long start = System.currentTimeMillis();
        try {
            Enumeration e;
            int fileCount;
            Hashtable links = new Hashtable();
            Vector files = new Vector();
            Object value = new Object();
            String basePath = TurbineResources.getString("services.freemarker.path");
            String[] templatePaths = new String[]{"layouts", "navigations", "screens"};
            int i = 0;
            while (true) {
                if (i >= templatePaths.length) break;
                File tempPath = new File(basePath, templatePaths[i]);
                this.dirRecurse(tempPath, files);
                ++i;
            }
            int i2 = 0;
            while (true) {
                block16: {
                    Object var15_16;
                    if (i2 >= files.size()) {
                        fileCount = 0;
                        e = links.keys();
                        break;
                    }
                    File file = (File)files.elementAt(i2);
                    BufferedReader in = null;
                    Object contents = null;
                    try {
                        in = new BufferedReader(new FileReader(file));
                        this.parseTemplateFile(in, links);
                        var15_16 = null;
                        if (in == null) break block16;
                    }
                    catch (Throwable throwable) {
                        var15_16 = null;
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                    in.close();
                }
                ++i2;
            }
            while (e.hasMoreElements()) {
                BufferedWriter[] out;
                block17: {
                    Object var25_27;
                    String templateName = (String)e.nextElement();
                    List alist = (List)links.get(templateName);
                    DynamicURIModel uriModel = new DynamicURIModel(data);
                    String uri = ((SimpleScalar)uriModel.exec(alist)).getAsString();
                    String useUrl = null;
                    String partialPath = null;
                    if (uri.startsWith("https")) {
                        useUrl = "http" + uri.substring(5);
                        partialPath = "../cooked_ssl";
                    } else {
                        useUrl = uri;
                        partialPath = "../cooked";
                    }
                    File cookedFile = new File(basePath + File.separator + partialPath, templateName);
                    File parent = new File(cookedFile.getParent());
                    if (!parent.exists() && !parent.equals(cookedFile)) {
                        parent.mkdirs();
                    }
                    if (cookedFile.exists()) continue;
                    System.out.println(++fileCount + ": " + cookedFile);
                    BufferedReader in = null;
                    out = new BufferedWriter[1];
                    try {
                        out[0] = new BufferedWriter(new FileWriter(cookedFile));
                        URL url = new URL(useUrl);
                        in = new BufferedReader(new InputStreamReader(url.openStream()));
                        this.parseFlatFile(uri, in, out);
                        System.out.println(fileCount + ": Successful");
                        var25_27 = null;
                        if (in == null) break block17;
                    }
                    catch (Throwable throwable) {
                        var25_27 = null;
                        if (in != null) {
                            in.close();
                        }
                        if (out[0] != null) {
                            out[0].close();
                        }
                        throw throwable;
                    }
                    in.close();
                }
                if (out[0] == null) continue;
                out[0].close();
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
        System.out.println("Time:" + (System.currentTimeMillis() - start) / 1000L);
    }

    private void dirRecurse(File basePath, Vector files) {
        String[] dirList = basePath.list();
        int i = 0;
        while (i < dirList.length) {
            File tempPath = new File(basePath, dirList[i]);
            if (tempPath.isDirectory()) {
                this.dirRecurse(tempPath, files);
            } else {
                files.addElement(tempPath);
            }
            ++i;
        }
    }

    private void parseTemplateFile(BufferedReader in, Hashtable links) throws Exception {
        char[] cbuf = new char[7];
        String templateName = null;
        StringBuffer argBuffer = new StringBuffer();
        LinkedList<String> args = new LinkedList<String>();
        boolean firstquote = false;
        boolean armed = false;
        int chint = in.read();
        while (chint != -1) {
            char ch = (char)chint;
            if (armed) {
                if (ch == '\"') {
                    boolean bl = firstquote = !firstquote;
                    if (!firstquote) {
                        String arg = argBuffer.toString();
                        args.add(arg);
                        argBuffer = new StringBuffer();
                        if (!arg.startsWith("http") && templateName == null) {
                            templateName = arg;
                        }
                    }
                } else if (firstquote) {
                    argBuffer.append(ch);
                } else if (ch == '}') {
                    links.put(templateName, args);
                    templateName = null;
                    args = new LinkedList();
                    armed = false;
                }
            } else {
                int i = 0;
                while (i < 6) {
                    cbuf[i] = cbuf[i + 1];
                    ++i;
                }
                cbuf[6] = ch;
                if (cbuf[0] == '$' && cbuf[1] == '{' && cbuf[2] == 'l' && cbuf[3] == 'i' && cbuf[4] == 'n' && cbuf[5] == 'k' && cbuf[6] == '(') {
                    armed = true;
                }
            }
            chint = in.read();
        }
    }

    private void parseFlatFile(String uri, BufferedReader in, BufferedWriter[] out) throws Exception {
        char[] cbuf = new char[4];
        Object templateName = null;
        StringBuffer uriBuffer = new StringBuffer();
        boolean armed = false;
        int chint = in.read();
        while (chint != -1) {
            char ch = (char)chint;
            int i = 0;
            while (i < out.length) {
                out[i].write(ch);
                ++i;
            }
            if (armed) {
                if (ch == '\"') {
                    this.parseUri(uri, in, out[0]);
                    armed = false;
                }
            } else {
                int i2 = 0;
                while (i2 < 3) {
                    cbuf[i2] = cbuf[i2 + 1];
                    ++i2;
                }
                cbuf[3] = ch;
                if (!(cbuf[0] != 'h' && cbuf[0] != 'H' || cbuf[1] != 'r' && cbuf[1] != 'R' || cbuf[2] != 'e' && cbuf[2] != 'E' || cbuf[3] != 'f' && cbuf[3] != 'F')) {
                    armed = true;
                }
            }
            chint = in.read();
        }
    }

    private void parseUri(String url, BufferedReader in, BufferedWriter out) throws Exception {
        int beginFile = url.indexOf("/template/") + 10;
        int endFile = url.indexOf(47, beginFile);
        if (endFile == -1) {
            endFile = url.indexOf(63, beginFile);
        }
        if (endFile == -1) {
            endFile = url.length();
        }
        String thisFilePath = url.substring(beginFile, endFile);
        char[] cbuf = new char[9];
        Object templateName = null;
        StringBuffer uriBuffer = new StringBuffer();
        boolean armed = false;
        boolean sameHost = true;
        while (true) {
            char ch = (char)in.read();
            if (armed) {
                String urlPart = uriBuffer.toString();
                if (!url.regionMatches(0, urlPart, 0, urlPart.length())) {
                    System.out.println("Hosts do not match:");
                    System.out.println("This file's url starts with: " + url.substring(0, urlPart.length()));
                    System.out.println("The link starts with:        " + urlPart);
                    out.write(urlPart, 0, urlPart.length());
                    sameHost = false;
                }
                int i = 0;
                boolean pathCounter = false;
                boolean firstMiss = true;
                boolean missedAtLeastOnce = false;
                uriBuffer = new StringBuffer();
                while (ch != '\"' && ch != '?') {
                    if (missedAtLeastOnce || !sameHost || ch != thisFilePath.charAt(i++)) {
                        if (sameHost && firstMiss) {
                            missedAtLeastOnce = true;
                            firstMiss = false;
                            String endPath = thisFilePath.substring(i);
                            char[] endPathArray = endPath.toCharArray();
                            int j = 0;
                            while (j < endPathArray.length - 2) {
                                if (endPathArray[j] == '%' && endPathArray[j + 1] == '2' && (endPathArray[j + 2] == 'c' || endPathArray[j + 2] == 'C')) {
                                    uriBuffer.append("../");
                                }
                                ++j;
                            }
                        }
                        if (ch == '%') {
                            char ch1 = (char)in.read();
                            char ch2 = (char)in.read();
                            if (ch1 == '2' && (ch2 == 'c' || ch2 == 'C')) {
                                uriBuffer.append('/');
                            } else {
                                uriBuffer.append(ch);
                                uriBuffer.append(ch1);
                                uriBuffer.append(ch2);
                            }
                        } else {
                            uriBuffer.append(ch);
                        }
                    }
                    ch = (char)in.read();
                }
                if (ch == '?') {
                    while (ch != '\"') {
                        ch = (char)in.read();
                    }
                }
                uriBuffer.append('\"');
                out.write(uriBuffer.toString(), 0, uriBuffer.length());
                break;
            }
            int i = 0;
            while (i < 8) {
                cbuf[i] = cbuf[i + 1];
                ++i;
            }
            cbuf[8] = ch;
            uriBuffer.append(ch);
            if (ch == '\"') {
                out.write(uriBuffer.toString(), 0, uriBuffer.length());
                break;
            }
            if (cbuf[0] != 't' || cbuf[1] != 'e' || cbuf[2] != 'm' || cbuf[3] != 'p' || cbuf[4] != 'l' || cbuf[5] != 'a' || cbuf[6] != 't' || cbuf[7] != 'e' || cbuf[8] != '/') continue;
            armed = true;
            uriBuffer.setLength(uriBuffer.length() - 10);
        }
    }
}

