/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.Vector;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class LayoutLoader
extends GenericLoader {
    private static LayoutLoader instance = new LayoutLoader(TurbineResources.getInt("layout.cache.size", 10));

    private LayoutLoader() {
    }

    private LayoutLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Layout layout) {
        if (this.cache()) {
            this.put(name, layout);
        }
    }

    public void exec(RunData data, String name) throws Exception {
        this.getInstance(name).build(data);
    }

    public Layout getInstance(String name) throws Exception {
        Layout layout = null;
        if (this.cache() && this.containsKey(name)) {
            layout = (Layout)this.get(name);
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                layout = (Layout)ab.getAssembler("layout", name);
            }
            catch (ClassCastException cce) {
                layout = null;
            }
            if (layout == null) {
                Vector packages = TurbineResources.getVector("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Layout not found: " + name + "\n" + "\tTurbine looked in the following modules.packages " + "path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, layout);
            }
        }
        return layout;
    }

    public static LayoutLoader getInstance() {
        return instance;
    }
}

