/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cactus.ServletURL;
import org.apache.cactus.server.RequestDispatcherWrapper;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;

public abstract class AbstractHttpServletRequestWrapper
implements HttpServletRequest {
    protected HttpServletRequest request;
    protected ServletURL url;
    private static Log logger = LogService.getInstance().getLog((class$org$apache$cactus$server$AbstractHttpServletRequestWrapper == null ? (class$org$apache$cactus$server$AbstractHttpServletRequestWrapper = AbstractHttpServletRequestWrapper.class$("org.apache.cactus.server.AbstractHttpServletRequestWrapper")) : class$org$apache$cactus$server$AbstractHttpServletRequestWrapper).getName());
    static /* synthetic */ Class class$org$apache$cactus$server$AbstractHttpServletRequestWrapper;

    public AbstractHttpServletRequestWrapper(HttpServletRequest theRequest, ServletURL theURL) {
        this.request = theRequest;
        this.url = theURL;
    }

    public HttpServletRequest getOriginalRequest() {
        return this.request;
    }

    public String getContextPath() {
        logger.entry("getContextPath()");
        String result = this.request.getContextPath();
        if (this.url != null && this.url.getContextPath() != null) {
            result = this.url.getContextPath();
            logger.debug("Using simulated context : [" + result + "]");
        }
        logger.exit("getContextPath");
        return result;
    }

    public String getPathInfo() {
        logger.entry("getPathInfo()");
        String result = this.request.getPathInfo();
        if (this.url != null) {
            result = this.url.getPathInfo();
            logger.debug("Using simulated PathInfo : [" + result + "]");
        }
        logger.exit("getPathInfo");
        return result;
    }

    public String getServerName() {
        logger.entry("getServerName()");
        String result = this.request.getServerName();
        if (this.url != null && this.url.getServerName() != null) {
            result = this.url.getHost();
            logger.debug("Using simulated server name : [" + result + "]");
        }
        logger.exit("getServerName");
        return result;
    }

    public int getServerPort() {
        logger.entry("getServerPort()");
        int result = this.request.getServerPort();
        if (this.url != null) {
            result = this.url.getPort() == -1 ? 80 : this.url.getPort();
            logger.debug("Using simulated server port : [" + result + "]");
        }
        logger.exit("getServerPort");
        return result;
    }

    public String getRequestURI() {
        logger.entry("getRequestURI()");
        String result = this.request.getRequestURI();
        if (this.url != null) {
            result = this.getContextPath() + (this.getServletPath() == null ? "" : this.getServletPath()) + (this.getPathInfo() == null ? "" : this.getPathInfo());
            logger.debug("Using simulated request URI : [" + result + "]");
        }
        logger.exit("getRequestURI");
        return result;
    }

    public String getServletPath() {
        logger.entry("getServletPath()");
        String result = this.request.getServletPath();
        if (this.url != null) {
            result = this.url.getServletPath();
            logger.debug("Using simulated servlet path : [" + result + "]");
        }
        logger.exit("getServletPath");
        return result;
    }

    public String getPathTranslated() {
        String pathTranslated;
        String pathInfo = this.url.getPathInfo();
        if (pathInfo != null) {
            String newPathInfo;
            String string = newPathInfo = pathInfo.startsWith("/") ? pathInfo.substring(1) : pathInfo;
            pathTranslated = this.request.getRealPath("/").endsWith("/") ? this.request.getRealPath("/") + newPathInfo.replace('/', File.separatorChar) : this.request.getRealPath("/") + File.separatorChar + newPathInfo.replace('/', File.separatorChar);
        } else {
            pathTranslated = this.request.getPathTranslated();
        }
        return pathTranslated;
    }

    public String getQueryString() {
        logger.entry("getQueryString()");
        String result = this.request.getQueryString();
        if (this.url != null) {
            result = this.url.getQueryString();
            logger.debug("Using simulated query string : [" + result + "]");
        }
        logger.exit("getQueryString");
        return result;
    }

    public RequestDispatcher getRequestDispatcher(String thePath) {
        String fullPath;
        logger.entry("getRequestDispatcher([" + thePath + "])");
        if (thePath == null) {
            logger.exit("getRequestDispatcher");
            return null;
        }
        RequestDispatcherWrapper dispatcher = null;
        if (thePath.startsWith("/")) {
            fullPath = thePath;
        } else {
            String pI = this.getPathInfo();
            fullPath = pI == null ? this.catPath(this.getServletPath(), thePath) : this.catPath(this.getServletPath() + pI, thePath);
            if (fullPath == null) {
                logger.exit("getRequestDispatcher");
                return null;
            }
        }
        logger.debug("Computed full path : [" + fullPath + "]");
        dispatcher = new RequestDispatcherWrapper(this.request.getRequestDispatcher(fullPath));
        logger.exit("getRequestDispatcher");
        return dispatcher;
    }

    private String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        lookupPath = lookupPath.substring(0, index);
        while (path.startsWith("../")) {
            if (lookupPath.length() <= 0) {
                return null;
            }
            index = lookupPath.lastIndexOf("/");
            lookupPath = lookupPath.substring(0, index);
            index = path.indexOf("../") + 3;
            path = path.substring(index);
        }
        return lookupPath + "/" + path;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isUserInRole(String theRole) {
        return this.request.isUserInRole(theRole);
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getHeader(String theName) {
        return this.request.getHeader(theName);
    }

    public Enumeration getHeaders(String theName) {
        return this.request.getHeaders(theName);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getRealPath(String thePath) {
        return this.request.getRealPath(thePath);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean isCreate) {
        return this.request.getSession(isCreate);
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String[] getParameterValues(String theName) {
        return this.request.getParameterValues(theName);
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public void removeAttribute(String theName) {
        this.request.removeAttribute(theName);
    }

    public String getParameter(String theName) {
        return this.request.getParameter(theName);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public void setAttribute(String theName, Object theAttribute) {
        this.request.setAttribute(theName, theAttribute);
    }

    public Object getAttribute(String theName) {
        return this.request.getAttribute(theName);
    }

    public int getIntHeader(String theName) {
        return this.request.getIntHeader(theName);
    }

    public long getDateHeader(String theName) {
        return this.request.getDateHeader(theName);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public abstract StringBuffer getRequestURL();

    public abstract void setCharacterEncoding(String var1) throws UnsupportedEncodingException;

    public abstract Map getParameterMap();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

