/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client;

import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.cactus.Cookie;
import org.apache.cactus.ServletURL;
import org.apache.cactus.WebRequest;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;
import org.apache.commons.httpclient.Header;

public class HttpClientHelper {
    private static Log logger = LogService.getInstance().getLog((class$org$apache$cactus$client$HttpClientHelper == null ? (class$org$apache$cactus$client$HttpClientHelper = HttpClientHelper.class$("org.apache.cactus.client.HttpClientHelper")) : class$org$apache$cactus$client$HttpClientHelper).getName());
    private String url;
    static /* synthetic */ Class class$org$apache$cactus$client$HttpClientHelper;

    public HttpClientHelper(String theURL) {
        logger.entry("HttpClientHelper([" + theURL + "])");
        this.url = theURL;
        logger.exit("HttpClientHelper");
    }

    private URL addParametersUsingGet(WebRequest theRequest, URL theURL) throws Throwable {
        int i;
        String[] values;
        String key;
        if (!theRequest.getParameterNames().hasMoreElements()) {
            return theURL;
        }
        StringBuffer queryString = new StringBuffer();
        Enumeration keys = theRequest.getParameterNames();
        if (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            values = theRequest.getParameterValues(key);
            queryString.append(key);
            queryString.append('=');
            queryString.append(URLEncoder.encode(values[0]));
            i = 1;
            while (i < values.length) {
                queryString.append('&');
                queryString.append(key);
                queryString.append('=');
                queryString.append(URLEncoder.encode(values[i]));
                ++i;
            }
        }
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            values = theRequest.getParameterValues(key);
            i = 0;
            while (i < values.length) {
                queryString.append('&');
                queryString.append(key);
                queryString.append('=');
                queryString.append(URLEncoder.encode(values[i]));
                ++i;
            }
        }
        String file = theURL.toString().indexOf("?") > 0 ? theURL.getFile() + "&" + queryString.toString() : theURL.getFile() + "?" + queryString.toString();
        return new URL(theURL.getProtocol(), theURL.getHost(), theURL.getPort(), file);
    }

    private void addParametersUsingPost(WebRequest theRequest, URLConnection theConnection) throws Throwable {
        int i;
        String[] values;
        String key;
        PrintWriter out;
        if (!theRequest.getParameterNames().hasMoreElements()) {
            return;
        }
        try {
            out = new PrintWriter(theConnection.getOutputStream());
        }
        catch (ConnectException e) {
            String reason = "Cannot connect to URL [" + theConnection.getURL() + "]. Reason : [" + e.getMessage() + "]\r\n";
            reason = reason + "Possible reasons :\r\n";
            reason = reason + "\t- The server is not running,\r\n";
            reason = reason + "\t- The server redirector is not correctly mapped in web.xml,\r\n";
            reason = reason + "\t- Something else ... !";
            throw new Exception(reason);
        }
        StringBuffer queryString = new StringBuffer();
        Enumeration keys = theRequest.getParameterNames();
        if (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            values = theRequest.getParameterValues(key);
            queryString.append(key);
            queryString.append('=');
            queryString.append(URLEncoder.encode(values[0]));
            i = 1;
            while (i < values.length) {
                queryString.append('&');
                queryString.append(key);
                queryString.append('=');
                queryString.append(URLEncoder.encode(values[i]));
                ++i;
            }
        }
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            values = theRequest.getParameterValues(key);
            i = 0;
            while (i < values.length) {
                queryString.append('&');
                queryString.append(key);
                queryString.append('=');
                queryString.append(URLEncoder.encode(values[i]));
                ++i;
            }
        }
        out.print(queryString.toString());
        out.close();
    }

    private void addCookies(WebRequest theRequest, URLConnection theConnection) {
        logger.entry("addCookies(...)");
        Vector cookies = theRequest.getCookies();
        if (!cookies.isEmpty()) {
            Vector<org.apache.commons.httpclient.Cookie> httpclientCookies = new Vector<org.apache.commons.httpclient.Cookie>();
            Enumeration enumCookies = cookies.elements();
            while (enumCookies.hasMoreElements()) {
                Cookie cactusCookie = (Cookie)enumCookies.nextElement();
                org.apache.commons.httpclient.Cookie httpclientCookie = new org.apache.commons.httpclient.Cookie(cactusCookie.getDomain(), cactusCookie.getName(), cactusCookie.getValue());
                httpclientCookie.setComment(cactusCookie.getComment());
                httpclientCookie.setExpiryDate(cactusCookie.getExpiryDate());
                httpclientCookie.setPath(cactusCookie.getPath());
                httpclientCookie.setSecure(cactusCookie.isSecure());
                httpclientCookies.addElement(httpclientCookie);
            }
            Header cookieHeader = org.apache.commons.httpclient.Cookie.createCookieHeader((String)HttpClientHelper.getDomain(theRequest, theConnection), (String)this.getPath(theRequest, theConnection), httpclientCookies);
            logger.debug("Cookie string = [" + cookieHeader.getValue() + "]");
            theConnection.setRequestProperty("Cookie", cookieHeader.getValue());
        }
        logger.exit("addCookies");
    }

    public static String getDomain(WebRequest theRequest, URLConnection theConnection) {
        logger.entry("getDomain(...)");
        ServletURL url = theRequest.getURL();
        String domain = url != null && url.getHost() != null ? url.getHost() : theConnection.getURL().getHost();
        logger.debug("Cookie validation domain = [" + domain + "]");
        logger.exit("getDomain");
        return domain;
    }

    private String getPath(WebRequest theRequest, URLConnection theConnection) {
        logger.entry("getPath(...)");
        ServletURL url = theRequest.getURL();
        String path = url != null && url.getPath() != null ? url.getPath() : theConnection.getURL().getPath();
        logger.debug("Cookie validation pah = [" + path + "]");
        logger.exit("getPath");
        return path;
    }

    private void addHeaders(WebRequest theRequest, URLConnection theConnection) {
        Enumeration keys = theRequest.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = theRequest.getHeaderValues(key);
            StringBuffer fullHeaderValue = new StringBuffer(values[0]);
            int i = 1;
            while (i < values.length) {
                fullHeaderValue.append("," + values[i]);
                ++i;
            }
            theConnection.setRequestProperty(key, fullHeaderValue.toString());
        }
    }

    public HttpURLConnection connect(WebRequest theRequest) throws Throwable {
        logger.entry("connect(" + theRequest + ")");
        URL url = new URL(this.url);
        if (theRequest.getMethod().equals("GET")) {
            url = this.addParametersUsingGet(theRequest, url);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        if (theRequest.getMethod().equals("POST")) {
            connection.setDoOutput(true);
        } else {
            connection.setDoOutput(false);
        }
        connection.setUseCaches(false);
        this.addHeaders(theRequest, connection);
        this.addCookies(theRequest, connection);
        if (theRequest.getMethod().equals("POST")) {
            this.addParametersUsingPost(theRequest, connection);
        }
        connection.connect();
        logger.exit("connect");
        return connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HttpURLConnection.setFollowRedirects(false);
    }
}

