/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;

public class Transaction {
    private static Category category = Category.getInstance((Class)(class$org$apache$torque$util$Transaction == null ? (class$org$apache$torque$util$Transaction = Transaction.class$("org.apache.torque.util.Transaction")) : class$org$apache$torque$util$Transaction));
    static /* synthetic */ Class class$org$apache$torque$util$Transaction;

    public static Connection begin(String dbName) throws TorqueException {
        return Transaction.beginOptional(dbName, true);
    }

    public static Connection beginOptional(String dbName, boolean useTransaction) throws TorqueException {
        Connection con = Torque.getConnection(dbName);
        try {
            if (con.getMetaData().supportsTransactions() && useTransaction) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        return con;
    }

    public static void commit(Connection con) throws TorqueException {
        if (con == null) {
            throw new NullPointerException("Connection object was null. This could be due to a misconfiguration of the DataSourceFactory.  Check the logs and Torque.properties to better determine the cause.");
        }
        try {
            block5: {
                try {
                    if (!con.getMetaData().supportsTransactions() || con.getAutoCommit()) break block5;
                    con.commit();
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    throw new TorqueException(e);
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            Torque.closeConnection(con);
            throw throwable;
        }
        Torque.closeConnection(con);
    }

    public static void rollback(Connection con) throws TorqueException {
        if (con == null) {
            throw new NullPointerException("Connection object was null. This could be due to a misconfiguration of the DataSourceFactory. Check the logs and Torque.properties to better determine the cause.");
        }
        try {
            block5: {
                try {
                    if (!con.getMetaData().supportsTransactions() || con.getAutoCommit()) break block5;
                    con.rollback();
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    category.error((Object)"An attempt was made to rollback a transaction but the database did not allow the operation to be rolled back.", (Throwable)e);
                    throw new TorqueException(e);
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            Torque.closeConnection(con);
            throw throwable;
        }
        Torque.closeConnection(con);
    }

    public static void safeRollback(Connection con) {
        try {
            Transaction.rollback(con);
        }
        catch (TorqueException e) {
            category.error((Object)"An error occured during rollback.", (Throwable)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

