/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDResolver
implements EntityResolver {
    private static final String WEB_SITE_DTD = "http://jakarta.apache.org/turbine/dtd/database.dtd";
    private InputSource databaseDTD = null;

    public DTDResolver() {
        try {
            InputStream dtdStream = this.getClass().getResourceAsStream("database.dtd");
            if (dtdStream != null) {
                this.databaseDTD = new InputSource(dtdStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.databaseDTD != null && WEB_SITE_DTD.equals(systemId)) {
            String pkg = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf("."));
            System.out.println("Resolver: used database.dtd from " + pkg + " package ");
            return this.databaseDTD;
        }
        if (systemId == null) {
            System.out.println("Resolver: used http://jakarta.apache.org/turbine/dtd/database.dtd");
            return this.getInputSource(WEB_SITE_DTD);
        }
        System.out.println("Resolver: used " + systemId);
        return this.getInputSource(systemId);
    }

    private InputSource getInputSource(String urlString) {
        try {
            URL url = new URL(urlString);
            return new InputSource(url.openStream());
        }
        catch (IOException ex) {
            System.err.println("Couldn't read DTD specified in XML schema: " + ex.getMessage());
            return new InputSource();
        }
    }
}

