/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.dsfactory;

import java.util.Iterator;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.log4j.Category;
import org.apache.torque.TorqueException;
import org.apache.torque.dsfactory.AbstractDataSourceFactory;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.pool.TorqueClassicDataSource;

public class TorqueDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    private static Category category = Category.getInstance((Class)(class$org$apache$torque$dsfactory$TorqueDataSourceFactory == null ? (class$org$apache$torque$dsfactory$TorqueDataSourceFactory = TorqueDataSourceFactory.class$("org.apache.torque.dsfactory.TorqueDataSourceFactory")) : class$org$apache$torque$dsfactory$TorqueDataSourceFactory));
    private DataSource ds;
    static /* synthetic */ Class class$org$apache$torque$dsfactory$TorqueDataSourceFactory;

    public DataSource getDataSource() {
        return this.ds;
    }

    public void initialize(Configuration configuration) throws TorqueException {
        if (configuration == null) {
            throw new TorqueException("Torque cannot be initialized without a valid configuration. Please check the log files for further details.");
        }
        ConnectionPoolDataSource cpds = this.initCPDS(configuration);
        TorqueClassicDataSource tcds = this.initTorqueClassic(configuration);
        tcds.setConnectionPoolDataSource(cpds);
        this.ds = tcds;
    }

    protected ConnectionPoolDataSource initCPDS(Configuration configuration) throws TorqueException {
        category.debug((Object)"Starting initCPDS");
        DriverAdapterCPDS cpds = new DriverAdapterCPDS();
        Configuration c = configuration.subset("connection");
        try {
            Iterator i = c.getKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                category.debug((Object)("Setting datasource property: " + key));
                this.setProperty(key, c, cpds);
            }
        }
        catch (Exception e) {
            category.error((Object)"", (Throwable)e);
            throw new TorqueException(e);
        }
        return cpds;
    }

    protected TorqueClassicDataSource initTorqueClassic(Configuration configuration) throws TorqueException {
        category.debug((Object)"Starting initTorqueClassic");
        TorqueClassicDataSource ds = new TorqueClassicDataSource();
        Configuration c = configuration.subset("pool");
        try {
            Iterator i = c.getKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                category.debug((Object)("Setting datasource property: " + key));
                this.setProperty(key, c, ds);
            }
        }
        catch (Exception e) {
            category.error((Object)"", (Throwable)e);
            throw new TorqueException(e);
        }
        return ds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

