/*
 * Decompiled with CFR 0.152.
 */
package slidestore.reference.fileDeleter;

import java.io.File;
import slidestore.reference.fileDeleter.DirectoryFilter;

public class DeleterWalker {
    private DirectoryFilter filter = new DirectoryFilter();

    public DeleterWalker(String path, String[] filterValues) {
        int i = 0;
        while (i < filterValues.length) {
            this.filter.addFileName(filterValues[i]);
            ++i;
        }
        this.walkDirectory(path);
    }

    public void walkDirectory(String path) {
        try {
            File rootFile = new File(path);
            String[] fileList = rootFile.list();
            if (fileList == null) {
                return;
            }
            int i = 0;
            while (i < fileList.length) {
                File currentFile = new File(String.valueOf(path) + "\\" + fileList[i]);
                if (currentFile.isDirectory()) {
                    this.walkDirectory(String.valueOf(path) + "\\" + currentFile.getName());
                }
                if (this.filter.accept(currentFile, path)) {
                    currentFile.delete();
                    File newFile = new File(path);
                    String[] check = newFile.list();
                    if (check.length == 0 && !newFile.delete()) {
                        System.out.println("UNABLE TO DELETE DIRECTORY " + newFile.getPath());
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

