/*
 * Decompiled with CFR 0.152.
 */
package slidestore.reference;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.AbstractSimpleService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class JDBCDescriptorsStore
extends AbstractSimpleService
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore {
    protected static final int OBJECTS_URI = 1;
    protected static final int OBJECTS_CLASS = 2;
    protected static final int CHILDREN_URI = 1;
    protected static final int CHILDREN_CHILDURI = 2;
    protected static final int LINKS_LINK = 1;
    protected static final int LINKS_LINKTO = 2;
    protected static final int PERMISSIONS_OBJECT = 1;
    protected static final int PERMISSIONS_REVISION_NUMBER = 2;
    protected static final int PERMISSIONS_SUBJECT = 3;
    protected static final int PERMISSIONS_ACTION = 4;
    protected static final int PERMISSIONS_INHERITABLE = 5;
    protected static final int PERMISSIONS_NEGATIVE = 6;
    protected static final int LOCKS_ID = 1;
    protected static final int LOCKS_OBJECT = 2;
    protected static final int LOCKS_SUBJECT = 3;
    protected static final int LOCKS_TYPE = 4;
    protected static final int LOCKS_EXPIRATIONDATE = 5;
    protected static final int LOCKS_INHERITABLE = 6;
    protected static final int LOCKS_EXCLUSIVE = 7;
    protected static final int REVISIONS_URI = 1;
    protected static final int REVISIONS_ISVERSIONED = 2;
    protected static final int REVISIONS_INITIALREVISION = 3;
    protected static final int WORKINGREVISION_URI = 1;
    protected static final int WORKINGREVISION_BASEREVISION = 2;
    protected static final int WORKINGREVISION_NUMBER = 3;
    protected static final int LATESTREVISIONS_URI = 1;
    protected static final int LATESTREVISIONS_BRANCHNAME = 2;
    protected static final int LATESTREVISIONS_NUMBER = 3;
    protected static final int BRANCHES_URI = 1;
    protected static final int BRANCHES_NUMBER = 2;
    protected static final int BRANCHES_CHILDNUMBER = 3;
    protected static final int REVISION_URI = 1;
    protected static final int REVISION_NUMBER = 2;
    protected static final int REVISION_BRANCHNAME = 3;
    protected static final int LABEL_URI = 1;
    protected static final int LABEL_NUMBER = 2;
    protected static final int LABEL_LABEL = 3;
    protected static final int PROPERTY_URI = 1;
    protected static final int PROPERTY_NUMBER = 2;
    protected static final int PROPERTY_NAME = 3;
    protected static final int PROPERTY_VALUE = 4;
    protected static final int PROPERTY_NAMESPACE = 5;
    protected static final int PROPERTY_TYPE = 6;
    protected static final int PROPERTY_PROTECTED = 7;
    protected Connection connection;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected int jdbcVersion;
    protected boolean alreadyEnlisted = false;

    protected void closeStatement(Statement statement) {
        block2: {
            if (statement == null) break block2;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                this.connectIfNeededAndPossible();
            }
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new XAException(101);
        }
        this.alreadyEnlisted = false;
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        this.getLogger().log((Object)("Connecting to \"" + this.url + "\" as user \"" + this.user + "\""), ((AbstractServiceBase)this).LOG_CHANNEL, 6);
        try {
            this.connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            this.getLogger().log((Object)("Connecting to \"" + this.url + "\" as user \"" + this.user + "\" failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            this.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceConnectionFailedException((Service)this, (Exception)e);
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {}
        Statement statement = null;
        try {
            try {
                statement = this.connection.createStatement();
                String[] statements = this.getDatabaseCreateStatements();
                int i = 0;
                while (i < statements.length) {
                    statement.execute(statements[i]);
                    ++i;
                }
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException sQLException2) {
                }
            }
            Object var3_5 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        this.alreadyEnlisted = false;
    }

    protected synchronized void connectIfNeededAndPossible() {
        try {
            this.connectIfNeeded();
        }
        catch (Throwable throwable) {}
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        PreparedStatement statement = null;
        try {
            try {
                String className = object.getClass().getName();
                statement = this.connection.prepareStatement("select * from objects where uri= ?");
                statement.setString(1, uri.toString());
                ResultSet res = statement.executeQuery();
                if (res.next()) {
                    throw new ObjectAlreadyExistsException(uri.toString());
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("insert into objects values(?,?)");
                statement.setString(1, uri.toString());
                statement.setString(2, className);
                statement.execute();
                this.closeStatement(statement);
                statement = null;
                Enumeration children = object.enumerateChildren();
                while (children.hasMoreElements()) {
                    if (statement == null) {
                        statement = this.connection.prepareStatement("insert into children values(?,?)");
                    }
                    statement.setString(1, uri.toString());
                    statement.setString(2, (String)children.nextElement());
                    statement.execute();
                }
                this.closeStatement(statement);
                if (object instanceof LinkNode) {
                    statement = this.connection.prepareStatement("insert into links values(?,?)");
                    statement.setString(1, uri.toString());
                    statement.setString(2, ((LinkNode)object).getLinkedUri());
                    statement.execute();
                    this.closeStatement(statement);
                }
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_8 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                Object res = null;
                statement = this.connection.prepareStatement("insert into revision values(?, ?, ?)");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                statement.setString(3, revisionDescriptor.getBranchName());
                statement.execute();
                this.closeStatement(statement);
                statement = null;
                Enumeration labels = revisionDescriptor.enumerateLabels();
                while (labels.hasMoreElements()) {
                    if (statement == null) {
                        statement = this.connection.prepareStatement("insert into label values(?,?,?)");
                    }
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                    statement.setString(3, (String)labels.nextElement());
                    statement.execute();
                }
                this.closeStatement(statement);
                statement = null;
                Enumeration properties = revisionDescriptor.enumerateProperties();
                while (properties.hasMoreElements()) {
                    NodeProperty property = (NodeProperty)properties.nextElement();
                    int protectedProperty = 0;
                    if (property.isProtected()) {
                        protectedProperty = 1;
                    }
                    if (statement == null) {
                        statement = this.connection.prepareStatement("insert into property values(?,?,?,?,?,?,?)");
                    }
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                    statement.setString(3, property.getName());
                    statement.setString(4, property.getValue().toString());
                    statement.setString(5, property.getNamespace());
                    statement.setString(6, property.getType());
                    statement.setInt(7, protectedProperty);
                    statement.execute();
                }
                this.closeStatement(statement);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_10 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                Object res = null;
                int isVersioned = 0;
                if (revisionDescriptors.isVersioned()) {
                    isVersioned = 1;
                }
                statement = this.connection.prepareStatement("insert into revisions values(?,?,?)");
                statement.setString(1, uri.toString());
                statement.setInt(2, isVersioned);
                statement.setString(3, revisionDescriptors.getInitialRevision().toString());
                statement.execute();
                this.closeStatement(statement);
                if (revisionDescriptors.getLatestRevision() != null) {
                    statement = this.connection.prepareStatement("insert into latestrevisions values(?,?,?)");
                    statement.setString(1, uri.toString());
                    statement.setString(2, "main".toString());
                    statement.setString(3, revisionDescriptors.getLatestRevision().toString());
                    statement.execute();
                    this.closeStatement(statement);
                }
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        this.getLogger().log((Object)("Disconnecting from \"" + this.url + "\" as user \"" + this.user + "\""), ((AbstractServiceBase)this).LOG_CHANNEL, 6);
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
        catch (SQLException e) {
            this.getLogger().log((Object)("Disconnecting from \"" + this.url + "\" as user \"" + this.user + "\" failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            this.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceDisconnectionFailedException((Service)this, (Exception)e);
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        Vector<NodeLock> lockVector = new Vector<NodeLock>();
        PreparedStatement statement = null;
        try {
            try {
                statement = this.connection.prepareStatement("select * from locks where object= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                ResultSet res = statement.getResultSet();
                while (res.next()) {
                    Date expirationDate = null;
                    try {
                        Long timeValue = new Long(res.getString(5));
                        expirationDate = new Date(timeValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        expirationDate = new Date();
                    }
                    NodeLock lock = new NodeLock(res.getString(1), res.getString(2), res.getString(3), res.getString(4), expirationDate, res.getInt(6) == 1, res.getInt(7) == 1);
                    lockVector.addElement(lock);
                }
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_8 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return lockVector.elements();
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissionVector = new Vector<NodePermission>();
        PreparedStatement statement = null;
        try {
            try {
                statement = this.connection.prepareStatement("select * from permissions where object= ?");
                statement.setString(1, uri.toString());
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String object = res.getString(1);
                    String revision = res.getString(2);
                    String subject = res.getString(3);
                    String action = res.getString(4);
                    boolean inheritable = false;
                    if (res.getInt(5) == 1) {
                        inheritable = true;
                    }
                    boolean negative = false;
                    if (res.getInt(6) == 1) {
                        negative = true;
                    }
                    NodePermission permission = new NodePermission(object, revision, subject, action, inheritable, negative);
                    permissionVector.addElement(permission);
                }
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_13 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return permissionVector.elements();
    }

    protected String getDatabaseConnectionTestStatement() {
        return "select 1 from objects where uri is null";
    }

    protected String[] getDatabaseCreateStatements() {
        String[] statements = new String[]{"create table objects(uri varchar(65536) primary key,    classname varchar(4096))", "create table children(uri varchar(65536),     childuri varchar(65536))", "create table links(link varchar(65536),     linkto varchar(65536))", "create table permissions(object varchar(65536),    revisionnumber varchar(20),     subject varchar(65536), action varchar(65536),     inheritable int, negative int)", "create table locks(id varchar(65536), object varchar(4096),    subject varchar(4096), type varchar(4096),     expirationdate varchar(15), inheritable int,     xexclusive int)", "create table revisions(uri varchar(65536) primary key,     isversioned int, initialrevision varchar(10))", "create table workingrevision(uri varchar(65536),     baserevision varchar(20), xnumber varchar(20))", "create table latestrevisions(uri varchar(65536),     branchname varchar(4096), xnumber varchar(20))", "create table branches(uri varchar(65536), xnumber varchar(20),    childnumber varchar(20))", "create table revision(uri varchar(65536), xnumber varchar(20),    branchname varchar(4096))", "create table label(uri varchar(65536), xnumber varchar(20),    label varchar(4096))", "create table property(uri varchar(65536), xnumber varchar(20),    name varchar(4096), value varchar(65536),     namespace varchar(4096), type varchar(100), protected int)"};
        return statements;
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                NodeRevisionNumber revisionNumber;
                int inheritable = 0;
                if (permission.isInheritable()) {
                    inheritable = 1;
                }
                int negative = 0;
                if (permission.isNegative()) {
                    negative = 1;
                }
                String revisionNumberStr = (revisionNumber = permission.getRevisionNumber()) == null ? null : revisionNumber.toString();
                statement = this.connection.prepareStatement("insert into permissions values(?,?,?,?,?,?)");
                statement.setString(1, permission.getObjectUri());
                statement.setString(2, revisionNumberStr);
                statement.setString(3, permission.getSubjectUri());
                statement.setString(4, permission.getActionUri());
                statement.setInt(5, inheritable);
                statement.setInt(6, negative);
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_9 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        try {
            token.getLogger().log((Object)("Loading and registering driver: " + this.driver), ((AbstractServiceBase)this).LOG_CHANNEL, 6);
            Class<?> driverClass = Class.forName(this.driver);
            Driver databaseDriver = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(databaseDriver);
        }
        catch (ClassNotFoundException e) {
            token.getLogger().log((Object)("Loading and registering driver " + this.driver + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (InstantiationException e) {
            token.getLogger().log((Object)("Loading and registering driver " + this.driver + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (IllegalAccessException e) {
            token.getLogger().log((Object)("Loading and registering driver " + this.driver + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (SQLException e) {
            token.getLogger().log((Object)("Loading and registering driver " + this.driver + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (ClassCastException e) {
            token.getLogger().log((Object)("Loading and registering driver " + this.driver + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
        catch (Exception e) {
            token.getLogger().log((Object)("Loading and registering driver " + this.driver + " failed"), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            token.getLogger().log((Object)e.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            throw new ServiceInitializationFailedException((Service)this, e.getMessage());
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return false;
            }
            PreparedStatement statement = this.connection.prepareStatement(this.getDatabaseConnectionTestStatement());
            statement.executeQuery();
            statement.close();
            return true;
        }
        catch (SQLException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(uri, lock);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                int inheritable = 0;
                if (lock.isInheritable()) {
                    inheritable = 1;
                }
                int exclusive = 0;
                if (lock.isExclusive()) {
                    exclusive = 1;
                }
                statement = this.connection.prepareStatement("insert into locks values(?,?,?,?,?,?,?)");
                statement.setString(1, lock.getLockId());
                statement.setString(2, lock.getObjectUri());
                statement.setString(3, lock.getSubjectUri());
                statement.setString(4, lock.getTypeUri());
                statement.setString(5, String.valueOf(lock.getExpirationDate().getTime()));
                statement.setInt(6, inheritable);
                statement.setInt(7, exclusive);
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        Statement statement = null;
        try {
            try {
                statement = this.connection.createStatement();
                boolean inheritable = false;
                if (lock.isInheritable()) {
                    inheritable = true;
                }
                String s = null;
                s = "delete from locks where id='" + lock.getLockId() + "'";
                statement.execute(s);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement("delete from objects where uri= ?");
            statement.setString(1, object.getUri());
            statement.execute();
            this.closeStatement(statement);
            statement = this.connection.prepareStatement("delete from children where uri=?");
            statement.setString(1, object.getUri());
            statement.execute();
            this.closeStatement(statement);
            statement = this.connection.prepareStatement("delete from links where link= ?");
            statement.setString(1, object.getUri());
            statement.execute();
            this.closeStatement(statement);
        }
        catch (SQLException e) {
            this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
            this.connectIfNeededAndPossible();
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = this.connection.prepareStatement("delete from revision where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, number.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from label where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, number.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from property where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, number.toString());
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_5 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = this.connection.prepareStatement("delete from revisions where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from workingrevision where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from latestrevisions where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from branches where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var4_4 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        PreparedStatement statement = null;
        try {
            try {
                int inheritable = 0;
                if (lock.isInheritable()) {
                    inheritable = 1;
                }
                int exclusive = 0;
                if (lock.isExclusive()) {
                    exclusive = 1;
                }
                statement = this.connection.prepareStatement("delete from locks where id=?");
                statement.setString(1, lock.getLockId());
                statement.execute();
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("insert into locks values(?,?,?,?,?,?,?)");
                statement.setString(1, lock.getLockId());
                statement.setString(2, lock.getObjectUri());
                statement.setString(3, lock.getSubjectUri());
                statement.setString(4, lock.getTypeUri());
                statement.setString(5, String.valueOf(lock.getExpirationDate().getTime()));
                statement.setInt(6, inheritable);
                statement.setInt(7, exclusive);
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public synchronized void reset() throws ServiceResetFailedException {
        Statement statement = null;
        try {
            try {
                this.connectIfNeeded();
                statement = this.connection.createStatement();
                String s = null;
                s = "drop table objects";
                statement.execute(s);
                s = "drop table children";
                statement.execute(s);
                s = "drop table links";
                statement.execute(s);
                s = "drop table permissions";
                statement.execute(s);
                s = "drop table locks";
                statement.execute(s);
                s = "drop table revisions";
                statement.execute(s);
                s = "drop table workingrevision";
                statement.execute(s);
                s = "drop table latestrevisions";
                statement.execute(s);
                s = "drop table branches";
                statement.execute(s);
                s = "drop table revision";
                statement.execute(s);
                s = "drop table label";
                statement.execute(s);
                s = "drop table property";
                statement.execute(s);
                statement.close();
                this.disconnect();
            }
            catch (SQLException e) {
                throw new ServiceResetFailedException((Service)this, e.getMessage());
            }
            catch (ServiceAccessException e) {
                throw new ServiceResetFailedException((Service)this, e.getMessage());
            }
            catch (ServiceConnectionFailedException e) {
                throw new ServiceResetFailedException((Service)this, e.getMessage());
            }
            catch (ServiceDisconnectionFailedException e) {
                throw new ServiceResetFailedException((Service)this, e.getMessage());
            }
            Object var3_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        LinkNode result = null;
        PreparedStatement statement = null;
        try {
            block11: {
                try {
                    statement = this.connection.prepareStatement("select * from objects where uri= ?");
                    statement.setString(1, uri.toString());
                    ResultSet res = statement.executeQuery();
                    if (!res.next()) {
                        throw new ObjectNotFoundException(uri);
                    }
                    String className = res.getString(2);
                    this.closeStatement(statement);
                    statement = this.connection.prepareStatement("select * from children where uri= ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    Vector<String> childrenVector = new Vector<String>();
                    while (res.next()) {
                        childrenVector.addElement(res.getString(2));
                    }
                    this.closeStatement(statement);
                    statement = this.connection.prepareStatement("select * from links where linkto= ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    Vector<String> linksVector = new Vector<String>();
                    while (res.next()) {
                        linksVector.addElement(res.getString(2));
                    }
                    this.closeStatement(statement);
                    if (className.equals("org.apache.slide.structure.LinkNode")) {
                        String linkTo = new String();
                        statement = this.connection.prepareStatement("select * from links where link= ?");
                        statement.setString(1, uri.toString());
                        res = statement.executeQuery();
                        if (res.next()) {
                            linkTo = res.getString(2);
                        }
                        this.closeStatement(statement);
                        result = new LinkNode(uri.toString(), childrenVector, linksVector, linkTo);
                        break block11;
                    }
                    try {
                        Class<?> objclass = Class.forName(className);
                        Class[] argClasses = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Vector"), Class.forName("java.util.Vector")};
                        Object[] arguments = new Object[]{uri.toString(), childrenVector, linksVector};
                        Constructor<?> constructor = objclass.getConstructor(argClasses);
                        result = (ObjectNode)constructor.newInstance(arguments);
                    }
                    catch (Exception e) {
                        throw new ServiceAccessException((Service)this, (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    this.connectIfNeededAndPossible();
                    throw new ServiceAccessException((Service)this, (Throwable)e);
                }
            }
            Object var5_15 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_16 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return result;
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptor revisionDescriptor = null;
        PreparedStatement statement = null;
        if (revisionNumber == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        try {
            try {
                ResultSet res = null;
                String branchName = null;
                Vector<String> labels = new Vector<String>();
                Hashtable<String, NodeProperty> properties = new Hashtable<String, NodeProperty>();
                statement = this.connection.prepareStatement("select * from revision where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                if (!res.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                branchName = res.getString(3);
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("select * from label where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    labels.addElement(res.getString(3));
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("select * from property where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    String propertyName = res.getString(3);
                    String propertyNamespace = res.getString(5);
                    NodeProperty property = new NodeProperty(propertyName, (Object)res.getString(4), propertyNamespace, res.getString(6), res.getInt(7) == 1);
                    properties.put(String.valueOf(propertyNamespace) + propertyName, property);
                }
                revisionDescriptor = new NodeRevisionDescriptor(revisionNumber, branchName, labels, properties);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_13 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return revisionDescriptor;
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptors revisionDescriptors = null;
        PreparedStatement statement = null;
        PreparedStatement statement2 = null;
        try {
            try {
                ResultSet res = null;
                NodeRevisionNumber initialRevision = new NodeRevisionNumber();
                Hashtable workingRevisions = new Hashtable();
                Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
                Hashtable branches = new Hashtable();
                boolean isVersioned = false;
                statement = this.connection.prepareStatement("select * from revisions where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                if (res.next()) {
                    int isVersionedInt = res.getInt(2);
                    if (isVersionedInt == 1) {
                        isVersioned = true;
                    }
                } else {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("select * from workingrevision where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("select * from latestrevisions where uri=?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    latestRevisionNumbers.put(res.getString(2), new NodeRevisionNumber(res.getString(3)));
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("select * from revision where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    String currentRevisionNumber = res.getString(2);
                    if (statement2 == null) {
                        statement2 = this.connection.prepareStatement("select * from branches where uri = ? and xnumber = ?");
                    }
                    statement2.setString(1, uri.toString());
                    statement2.setString(2, currentRevisionNumber);
                    ResultSet res2 = statement2.executeQuery();
                    Vector<NodeRevisionNumber> childList = new Vector<NodeRevisionNumber>();
                    while (res2.next()) {
                        childList.addElement(new NodeRevisionNumber(res2.getString(3)));
                    }
                    branches.put(new NodeRevisionNumber(currentRevisionNumber), childList);
                    res2.close();
                }
                this.closeStatement(statement2);
                revisionDescriptors = new NodeRevisionDescriptors(uri.toString(), initialRevision, workingRevisions, latestRevisionNumbers, branches, isVersioned);
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_16 = null;
            this.closeStatement(statement);
            this.closeStatement(statement2);
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            this.closeStatement(statement);
            this.closeStatement(statement2);
            throw throwable;
        }
        return revisionDescriptors;
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
                if (revisionNumber != null) {
                    statement = this.connection.prepareStatement("delete from permissions where object= ? and subject = ? and action = ?  and revisionnumber = ? ");
                    statement.setString(4, revisionNumber.toString());
                } else {
                    statement = this.connection.prepareStatement("delete from permissions where object = ? and subject = ? and action = ? and revisionnumber is NULL");
                }
                statement.setString(1, permission.getObjectUri());
                statement.setString(2, permission.getSubjectUri());
                statement.setString(3, permission.getActionUri());
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_6 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = this.connection.prepareStatement("delete from permissions where object= ?");
                statement.setString(1, uri.toString());
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var4_4 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new XAException(7);
        }
        this.alreadyEnlisted = false;
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.driver = (String)parameters.get("driver");
        this.url = (String)parameters.get("url");
        if (!this.url.startsWith("jdbc:")) {
            this.url = "jdbc:" + this.url;
        }
        this.user = (String)parameters.get("user");
        if (this.user == null) {
            this.user = new String();
        }
        this.password = (String)parameters.get("password");
        if (this.password == null) {
            this.password = new String();
        }
        this.jdbcVersion = 1;
        String version = (String)parameters.get("jdbcversion");
        if (version != null) {
            this.jdbcVersion = new Integer(version);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        super.start(xid, flags);
        if (!this.alreadyEnlisted) {
            try {
                this.connectIfNeeded();
                this.connection.rollback();
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.alreadyEnlisted = true;
        }
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            try {
                statement = this.connection.prepareStatement("select * from objects where uri= ?");
                statement.setString(1, uri.toString());
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    throw new ObjectNotFoundException(uri);
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from children where uri= ?");
                statement.setString(1, object.getUri());
                statement.execute();
                this.closeStatement(statement);
                statement = null;
                Enumeration children = object.enumerateChildren();
                while (children.hasMoreElements()) {
                    if (statement == null) {
                        statement = this.connection.prepareStatement("insert into children values(?, ?)");
                    }
                    statement.setString(1, object.getUri());
                    statement.setString(2, (String)children.nextElement());
                    statement.execute();
                }
                this.closeStatement(statement);
                statement = this.connection.prepareStatement("delete from links where link= ?");
                statement.setString(1, object.getUri());
                statement.execute();
                this.closeStatement(statement);
                if (object instanceof LinkNode) {
                    statement = this.connection.prepareStatement("insert into links values(?,?)");
                    statement.setString(1, object.getUri());
                    statement.setString(2, ((LinkNode)object).getLinkedUri());
                    statement.execute();
                    this.closeStatement(statement);
                }
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                this.connectIfNeededAndPossible();
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptor(uri, revisionDescriptor.getRevisionNumber());
        this.createRevisionDescriptor(uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptors(uri);
        this.createRevisionDescriptors(uri, revisionDescriptors);
    }
}

