/*
 * Decompiled with CFR 0.152.
 */
package slidestore.file;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class AbstractUriProperties {
    protected ObjectNode object;
    protected Vector permissions;
    protected Vector locks;
    protected NodeRevisionDescriptors revisionDescriptors;
    protected Hashtable descriptor;
    protected String rootpath;

    public AbstractUriProperties(String aRootPath, Uri aUri) {
        this.rootpath = aRootPath;
    }

    public void createObject(Uri uri, ObjectNode aObject) throws ServiceAccessException, ObjectAlreadyExistsException {
        try {
            if (this.object.getUri().equals(uri.toString())) {
                throw new ObjectAlreadyExistsException(uri.toString());
            }
            this.storeObject(uri, aObject);
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor aRevisionDescriptor) throws ServiceAccessException {
        if (this.descriptor == null) {
            this.descriptor = new Hashtable();
        }
        this.descriptor.put(aRevisionDescriptor.getRevisionNumber().toString(), aRevisionDescriptor.cloneObject());
        this.save(uri);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors aRevisionDescriptors) throws ServiceAccessException {
        this.revisionDescriptors = aRevisionDescriptors.cloneObject();
        this.save(uri);
    }

    public Enumeration enumerateLocks() throws ServiceAccessException {
        if (this.locks == null) {
            this.locks = new Vector();
        }
        return this.locks.elements();
    }

    public Enumeration enumeratePermissions() throws ServiceAccessException {
        if (this.permissions == null) {
            this.permissions = new Vector();
        }
        return this.permissions.elements();
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        if (this.permissions == null) {
            this.permissions = new Vector();
        }
        this.permissions.addElement(permission.cloneObject());
        this.save(uri);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        if (this.locks == null) {
            this.locks = new Vector();
        }
        this.locks.addElement(lock.cloneObject());
        this.save(uri);
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        if (this.locks == null) {
            throw new LockTokenNotFoundException(lock);
        }
        boolean wasPresent = this.locks.removeElement(lock);
        if (!wasPresent) {
            throw new LockTokenNotFoundException(lock);
        }
        this.save(uri);
    }

    public void removeObject(Uri uri, ObjectNode aObject) throws ServiceAccessException, ObjectNotFoundException {
        this.object = null;
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        if (this.descriptor == null) {
            return;
        }
        this.descriptor.remove(number.toString());
        this.save(uri);
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        this.revisionDescriptors = null;
        this.save(uri);
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        boolean wasPresent;
        if (this.locks == null) {
            this.locks = new Vector();
        }
        if (!(wasPresent = this.locks.removeElement(lock))) {
            throw new LockTokenNotFoundException(lock);
        }
        this.locks.addElement(lock.cloneObject());
        this.save(uri);
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        if (this.object == null) {
            throw new ObjectNotFoundException(uri);
        }
        return this.object.cloneObject();
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        Object result = null;
        if (this.descriptor != null && revisionNumber != null) {
            result = this.descriptor.get(revisionNumber.toString());
        }
        if (result == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        return ((NodeRevisionDescriptor)result).cloneObject();
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptors == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        return this.revisionDescriptors.cloneObject();
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        if (this.permissions != null) {
            this.permissions.removeElement(permission);
        }
        this.save(uri);
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        if (this.permissions != null) {
            this.permissions.removeAllElements();
        }
        this.save(uri);
    }

    protected void save(Uri aUri) throws ServiceAccessException {
    }

    public void storeObject(Uri uri, ObjectNode aObject) throws ServiceAccessException, ObjectNotFoundException {
        this.object = aObject.cloneObject();
        this.save(uri);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor aRevisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        String key = aRevisionDescriptor.getRevisionNumber().toString();
        if (this.descriptor == null || !this.descriptor.containsKey(key)) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        this.descriptor.put(key, aRevisionDescriptor.cloneObject());
        this.save(uri);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors aRevisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (!this.revisionDescriptors.getUri().equals(uri.toString())) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        this.revisionDescriptors = aRevisionDescriptors.cloneObject();
        this.save(uri);
    }
}

